/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.TupleDomain;
import java.nio.ByteBuffer;

public class CassandraPartition
implements Partition {
    static final String UNPARTITIONED_ID = "<UNPARTITIONED>";
    public static final CassandraPartition UNPARTITIONED = new CassandraPartition();
    private final String partitionId;
    private final byte[] key;
    private final TupleDomain tupleDomain;

    private CassandraPartition() {
        this.partitionId = UNPARTITIONED_ID;
        this.tupleDomain = TupleDomain.all();
        this.key = null;
    }

    public CassandraPartition(byte[] key, String partitionId, TupleDomain tupleDomain) {
        this.key = key;
        this.partitionId = partitionId;
        this.tupleDomain = tupleDomain;
    }

    public boolean isUnpartitioned() {
        return this.partitionId.equals(UNPARTITIONED_ID);
    }

    public TupleDomain getTupleDomain() {
        return this.tupleDomain;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public String toString() {
        return this.partitionId;
    }

    public ByteBuffer getKeyAsByteBuffer() {
        return ByteBuffer.wrap(this.key);
    }
}

