/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraColumnHandle;
import com.facebook.presto.cassandra.CassandraConnectorId;
import com.facebook.presto.cassandra.CassandraRecordSet;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.cassandra.CassandraSplit;
import com.facebook.presto.cassandra.util.CassandraCqlUtils;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.Split;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import java.util.List;

public class CassandraRecordSetProvider
implements ConnectorRecordSetProvider {
    private static final Logger log = Logger.get(ConnectorRecordSetProvider.class);
    private final String connectorId;
    private final CassandraSession cassandraSession;

    @Inject
    public CassandraRecordSetProvider(CassandraConnectorId connectorId, CassandraSession cassandraSession) {
        this.connectorId = ((CassandraConnectorId)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null")).toString();
        this.cassandraSession = (CassandraSession)Preconditions.checkNotNull((Object)cassandraSession, (Object)"cassandraSession is null");
    }

    public RecordSet getRecordSet(Split split, List<? extends ColumnHandle> columns) {
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Preconditions.checkArgument((boolean)(split instanceof CassandraSplit), (String)"expected instance of %s: %s", (Object[])new Object[]{CassandraSplit.class, split.getClass()});
        CassandraSplit cassandraSplit = (CassandraSplit)split;
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        ImmutableList cassandraColumns = ImmutableList.copyOf((Iterable)Iterables.transform(columns, CassandraColumnHandle.cassandraColumnHandle()));
        String selectCql = CassandraCqlUtils.selectFrom(cassandraSplit.getCassandraTableHandle(), (List<CassandraColumnHandle>)cassandraColumns).getQueryString();
        StringBuilder sb = new StringBuilder(selectCql);
        if (sb.charAt(sb.length() - 1) == ';') {
            sb.setLength(sb.length() - 1);
        }
        sb.append(cassandraSplit.getWhereClause());
        String cql = sb.toString();
        log.debug("Creating record set: %s", new Object[]{cql});
        return new CassandraRecordSet(this.cassandraSession, cql, (List<CassandraColumnHandle>)cassandraColumns);
    }

    public boolean canHandle(Split split) {
        return split instanceof CassandraSplit && ((CassandraSplit)split).getConnectorId().equals(this.connectorId);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).toString();
    }
}

