/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.facebook.presto.cassandra.CassandraColumnHandle;
import com.facebook.presto.cassandra.CassandraPartition;
import com.facebook.presto.cassandra.CassandraTable;
import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.cassandra.CassandraType;
import com.facebook.presto.cassandra.util.CassandraCqlUtils;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CassandraSession {
    protected final String connectorId;
    private final Session session;
    private final int limitForPartitionKeySelect;
    private final int fetchSizeForPartitionKeySelect;

    public CassandraSession(String connectorId, Session session, int fetchSizeForPartitionKeySelect, int limitForPartitionKeySelect) {
        this.connectorId = connectorId;
        this.session = session;
        this.fetchSizeForPartitionKeySelect = fetchSizeForPartitionKeySelect;
        this.limitForPartitionKeySelect = limitForPartitionKeySelect;
    }

    public Set<Host> getReplicas(String schema, ByteBuffer partitionKey) {
        return this.session.getCluster().getMetadata().getReplicas(schema, partitionKey);
    }

    public ResultSet executeQuery(String cql) {
        return this.session.execute(cql);
    }

    public Collection<Host> getAllHosts() {
        return this.session.getCluster().getMetadata().getAllHosts();
    }

    public List<String> getAllSchemas() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (KeyspaceMetadata meta : this.session.getCluster().getMetadata().getKeyspaces()) {
            builder.add((Object)meta.getName());
        }
        return builder.build();
    }

    public List<String> getAllTables(String schema) throws SchemaNotFoundException {
        KeyspaceMetadata meta = this.getCheckedKeyspaceMetadata(schema);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TableMetadata tableMeta : meta.getTables()) {
            builder.add((Object)tableMeta.getName());
        }
        return builder.build();
    }

    private KeyspaceMetadata getCheckedKeyspaceMetadata(String schema) throws SchemaNotFoundException {
        KeyspaceMetadata meta = this.session.getCluster().getMetadata().getKeyspace(schema);
        if (meta == null) {
            throw new SchemaNotFoundException(schema);
        }
        return meta;
    }

    public void getSchema(String schema) throws SchemaNotFoundException {
        this.getCheckedKeyspaceMetadata(schema);
    }

    public CassandraTable getTable(SchemaTableName tableName) throws TableNotFoundException {
        CassandraColumnHandle columnHandle;
        TableMetadata tableMeta = this.getTableMetadata(tableName);
        ImmutableList.Builder columnHandles = ImmutableList.builder();
        HashSet<String> primaryKeySet = new HashSet<String>();
        int index = 0;
        for (ColumnMetadata columnMeta : tableMeta.getPartitionKey()) {
            primaryKeySet.add(columnMeta.getName());
            columnHandle = this.buildColumnHandle(columnMeta, true, false, index++);
            columnHandles.add((Object)columnHandle);
        }
        index = 0;
        for (ColumnMetadata columnMeta : tableMeta.getClusteringColumns()) {
            primaryKeySet.add(columnMeta.getName());
            columnHandle = this.buildColumnHandle(columnMeta, false, true, index++);
            columnHandles.add((Object)columnHandle);
        }
        for (ColumnMetadata columnMeta : tableMeta.getColumns()) {
            if (primaryKeySet.contains(columnMeta.getName())) continue;
            columnHandle = this.buildColumnHandle(columnMeta, false, false, 0);
            columnHandles.add((Object)columnHandle);
        }
        CassandraTableHandle tableHandle = new CassandraTableHandle(this.connectorId, tableMeta.getKeyspace().getName(), tableMeta.getName());
        return new CassandraTable(tableHandle, (List<CassandraColumnHandle>)columnHandles.build());
    }

    private TableMetadata getTableMetadata(SchemaTableName schemaTableName) {
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        KeyspaceMetadata keyspaceMetadata = this.getCheckedKeyspaceMetadata(schemaName);
        TableMetadata tableMetadata = keyspaceMetadata.getTable(tableName);
        if (tableMetadata != null) {
            return tableMetadata;
        }
        for (TableMetadata table : keyspaceMetadata.getTables()) {
            if (!table.getName().equalsIgnoreCase(tableName)) continue;
            return table;
        }
        throw new TableNotFoundException(schemaTableName);
    }

    private CassandraColumnHandle buildColumnHandle(ColumnMetadata columnMeta, boolean partitionKey, boolean clusteringKey, int index) {
        CassandraType cassandraType = CassandraType.getCassandraType(columnMeta.getType().getName());
        ImmutableList typeArguments = null;
        if (cassandraType != null && cassandraType.getTypeArgumentSize() > 0) {
            List typeArgs = columnMeta.getType().getTypeArguments();
            switch (cassandraType.getTypeArgumentSize()) {
                case 1: {
                    typeArguments = ImmutableList.of((Object)CassandraType.getCassandraType(((DataType)typeArgs.get(0)).getName()));
                    break;
                }
                case 2: {
                    typeArguments = ImmutableList.of((Object)CassandraType.getCassandraType(((DataType)typeArgs.get(0)).getName()), (Object)CassandraType.getCassandraType(((DataType)typeArgs.get(1)).getName()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid type arguments: " + typeArgs);
                }
            }
        }
        return new CassandraColumnHandle(this.connectorId, columnMeta.getName(), index, cassandraType, (List<CassandraType>)typeArguments, partitionKey, clusteringKey);
    }

    public List<CassandraPartition> getPartitions(CassandraTable table, List<Comparable<?>> filterPrefix) {
        Iterable<Row> rows = this.queryPartitionKeys(table, filterPrefix);
        if (rows == null) {
            return ImmutableList.of((Object)CassandraPartition.UNPARTITIONED);
        }
        List<CassandraColumnHandle> partitionKeyColumns = table.getPartitionKeyColumns();
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        HashMap map = new HashMap();
        HashSet<String> uniquePartitionIds = new HashSet<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean isComposite = partitionKeyColumns.size() > 1;
        ImmutableList.Builder partitions = ImmutableList.builder();
        for (Row row : rows) {
            buffer.clear();
            map.clear();
            stringBuilder.setLength(0);
            for (int i = 0; i < partitionKeyColumns.size(); ++i) {
                ByteBuffer component = row.getBytesUnsafe(i);
                if (isComposite) {
                    short len = (short)component.limit();
                    buffer.putShort(len);
                    buffer.put(component);
                    buffer.put((byte)0);
                } else {
                    buffer.put(component);
                }
                CassandraColumnHandle columnHandle = partitionKeyColumns.get(i);
                Comparable<?> keyPart = CassandraType.getColumnValue(row, i, columnHandle.getCassandraType(), columnHandle.getTypeArguments());
                map.put(columnHandle, keyPart);
                if (i > 0) {
                    stringBuilder.append(" AND ");
                }
                stringBuilder.append(CassandraCqlUtils.validColumnName(columnHandle.getName()));
                stringBuilder.append(" = ");
                stringBuilder.append(CassandraType.getColumnValueForCql(row, i, columnHandle.getCassandraType()));
            }
            buffer.flip();
            byte[] key = new byte[buffer.limit()];
            buffer.get(key);
            TupleDomain tupleDomain = TupleDomain.withFixedValues(map);
            String partitionId = stringBuilder.toString();
            if (!uniquePartitionIds.add(partitionId)) continue;
            partitions.add((Object)new CassandraPartition(key, partitionId, tupleDomain));
        }
        return partitions.build();
    }

    protected Iterable<Row> queryPartitionKeys(CassandraTable table, List<Comparable<?>> filterPrefix) {
        long count;
        ResultSetFuture countFuture;
        boolean fullPartitionKey;
        CassandraTableHandle tableHandle = table.getTableHandle();
        List<CassandraColumnHandle> partitionKeyColumns = table.getPartitionKeyColumns();
        boolean bl = fullPartitionKey = filterPrefix.size() == partitionKeyColumns.size();
        if (!fullPartitionKey) {
            Select countAll = CassandraCqlUtils.selectCountAllFrom(tableHandle).limit(this.limitForPartitionKeySelect);
            countFuture = this.session.executeAsync((Statement)countAll);
        } else {
            countFuture = null;
        }
        int limit = fullPartitionKey ? 1 : this.limitForPartitionKeySelect;
        Select partitionKeys = CassandraCqlUtils.selectDistinctFrom(tableHandle, partitionKeyColumns);
        partitionKeys.limit(limit);
        partitionKeys.setFetchSize(this.fetchSizeForPartitionKeySelect);
        this.addWhereClause(partitionKeys.where(), partitionKeyColumns, filterPrefix);
        ResultSetFuture partitionKeyFuture = this.session.executeAsync((Statement)partitionKeys);
        if (!fullPartitionKey && (count = countFuture.getUninterruptibly().one().getLong(0)) == (long)this.limitForPartitionKeySelect) {
            partitionKeyFuture.cancel(true);
            return null;
        }
        return partitionKeyFuture.getUninterruptibly();
    }

    private void addWhereClause(Select.Where where, List<CassandraColumnHandle> partitionKeyColumns, List<Comparable<?>> filterPrefix) {
        for (int i = 0; i < filterPrefix.size(); ++i) {
            CassandraColumnHandle column = partitionKeyColumns.get(i);
            Object value = column.getCassandraType().getJavaValue(filterPrefix.get(i));
            Clause clause = QueryBuilder.eq((String)CassandraCqlUtils.validColumnName(column.getName()), (Object)value);
            where.and(clause);
        }
    }
}

