/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.Session;
import com.facebook.presto.cassandra.CassandraClientConfig;
import com.facebook.presto.cassandra.CassandraConnectorId;
import com.facebook.presto.cassandra.CassandraSession;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.inject.Inject;

public class CassandraSessionFactory {
    private final CassandraConnectorId connectorId;
    private final List<String> contactPoints;
    private final int fetchSize;
    private final ConsistencyLevel consistencyLevel;
    private final int fetchSizeForPartitionKeySelect;
    private final int limitForPartitionKeySelect;
    private final int nativeProtocolPort;

    @Inject
    public CassandraSessionFactory(CassandraConnectorId connectorId, CassandraClientConfig config) {
        this.connectorId = (CassandraConnectorId)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        Preconditions.checkNotNull((Object)config, (Object)"config is null");
        this.contactPoints = (List)Preconditions.checkNotNull(config.getContactPoints(), (Object)"contactPoints is null");
        Preconditions.checkArgument((this.contactPoints.size() > 0 ? 1 : 0) != 0, (Object)"empty contactPoints");
        this.nativeProtocolPort = config.getNativeProtocolPort();
        this.fetchSize = config.getFetchSize();
        this.consistencyLevel = config.getConsistencyLevel();
        this.fetchSizeForPartitionKeySelect = config.getFetchSizeForPartitionKeySelect();
        this.limitForPartitionKeySelect = config.getLimitForPartitionKeySelect();
    }

    public CassandraSession create() {
        Cluster.Builder clusterBuilder = Cluster.builder();
        clusterBuilder.addContactPoints(this.contactPoints.toArray(new String[this.contactPoints.size()]));
        clusterBuilder.withPort(this.nativeProtocolPort);
        QueryOptions options = new QueryOptions();
        options.setFetchSize(this.fetchSize);
        options.setConsistencyLevel(this.consistencyLevel);
        clusterBuilder.withQueryOptions(options);
        Cluster cluster = clusterBuilder.build();
        Session session = cluster.connect();
        return new CassandraSession(this.connectorId.toString(), session, this.fetchSizeForPartitionKeySelect, this.limitForPartitionKeySelect);
    }
}

