/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.datastax.driver.core.Host;
import com.facebook.presto.cassandra.CachingCassandraSchemaProvider;
import com.facebook.presto.cassandra.CassandraClientConfig;
import com.facebook.presto.cassandra.CassandraColumnHandle;
import com.facebook.presto.cassandra.CassandraConnectorId;
import com.facebook.presto.cassandra.CassandraPartition;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.cassandra.CassandraSplit;
import com.facebook.presto.cassandra.CassandraTable;
import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.cassandra.util.HostAddressFactory;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.Domain;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.PartitionResult;
import com.facebook.presto.spi.Range;
import com.facebook.presto.spi.Split;
import com.facebook.presto.spi.SplitSource;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CassandraSplitManager
implements ConnectorSplitManager {
    private static final Logger log = Logger.get(ConnectorSplitManager.class);
    private final String connectorId;
    private final CassandraSession cassandraSession;
    private final CachingCassandraSchemaProvider schemaProvider;
    private final int unpartitionedSplits;

    @Inject
    public CassandraSplitManager(CassandraConnectorId connectorId, CassandraClientConfig cassandraClientConfig, CassandraSession cassandraSession, CachingCassandraSchemaProvider schemaProvider) {
        this.connectorId = ((CassandraConnectorId)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null")).toString();
        this.schemaProvider = (CachingCassandraSchemaProvider)Preconditions.checkNotNull((Object)schemaProvider, (Object)"schemaProvider is null");
        this.cassandraSession = (CassandraSession)Preconditions.checkNotNull((Object)cassandraSession, (Object)"cassandraSession is null");
        this.unpartitionedSplits = cassandraClientConfig.getUnpartitionedSplits();
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public boolean canHandle(TableHandle tableHandle) {
        return tableHandle instanceof CassandraTableHandle && ((CassandraTableHandle)tableHandle).getConnectorId().equals(this.connectorId);
    }

    public PartitionResult getPartitions(TableHandle tableHandle, TupleDomain tupleDomain) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkNotNull((Object)tupleDomain, (Object)"tupleDomain is null");
        CassandraTableHandle cassandraTableHandle = (CassandraTableHandle)tableHandle;
        CassandraTable table = this.schemaProvider.getTable(cassandraTableHandle);
        List<CassandraColumnHandle> partitionKeys = table.getPartitionKeyColumns();
        ArrayList filterPrefix = new ArrayList();
        for (int i = 0; i < partitionKeys.size(); ++i) {
            Range range;
            Domain domain;
            CassandraColumnHandle columnHandle = partitionKeys.get(i);
            if (filterPrefix.size() != i || tupleDomain.isNone() || (domain = (Domain)tupleDomain.getDomains().get(columnHandle)) == null || domain.getRanges().getRangeCount() != 1 || !(range = (Range)Iterables.getOnlyElement((Iterable)domain.getRanges())).isSingleValue()) continue;
            Comparable value = range.getLow().getValue();
            Preconditions.checkArgument((value instanceof Boolean || value instanceof String || value instanceof Double || value instanceof Long ? 1 : 0) != 0, (Object)"Only Boolean, String, Double and Long partition keys are supported");
            filterPrefix.add(value);
        }
        List<CassandraPartition> allPartitions = this.schemaProvider.getPartitions(table, filterPrefix);
        log.debug("%s.%s #partitions: %d", new Object[]{cassandraTableHandle.getSchemaName(), cassandraTableHandle.getTableName(), allPartitions.size()});
        ImmutableList partitions = FluentIterable.from(allPartitions).filter(CassandraSplitManager.partitionMatches(tupleDomain)).filter(Partition.class).toList();
        TupleDomain remainingTupleDomain = TupleDomain.none();
        if (!tupleDomain.isNone()) {
            List<CassandraColumnHandle> partitionColumns = partitionKeys;
            remainingTupleDomain = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)tupleDomain.getDomains(), (Predicate)Predicates.not((Predicate)Predicates.in(partitionColumns))));
        }
        return new PartitionResult((List)partitions, remainingTupleDomain);
    }

    public SplitSource getPartitionSplits(TableHandle tableHandle, List<Partition> partitions) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof CassandraTableHandle), (Object)"tableHandle is not an instance of CassandraTableHandle");
        CassandraTableHandle cassandraTableHandle = (CassandraTableHandle)tableHandle;
        Preconditions.checkNotNull(partitions, (Object)"partitions is null");
        if (partitions.isEmpty()) {
            return new FixedSplitSource(this.connectorId, (Iterable)ImmutableList.of());
        }
        if (partitions.size() == 1) {
            Partition partition = partitions.get(0);
            Preconditions.checkArgument((boolean)(partition instanceof CassandraPartition), (Object)"partitions are no CassandraPartitions");
            CassandraPartition cassandraPartition = (CassandraPartition)partition;
            if (cassandraPartition.isUnpartitioned()) {
                CassandraTable table = this.schemaProvider.getTable(cassandraTableHandle);
                List<Split> splits = this.getSplitsByTokenRange(table, cassandraPartition.getPartitionId());
                return new FixedSplitSource(this.connectorId, splits);
            }
        }
        return new FixedSplitSource(this.connectorId, this.getSplitsForPartitions(cassandraTableHandle, partitions));
    }

    private List<Split> getSplitsByTokenRange(CassandraTable table, String partitionId) {
        String schema = table.getTableHandle().getSchemaName();
        String tableName = table.getTableHandle().getTableName();
        String tokenExpression = table.getTokenExpression();
        List<HostAddress> addresses = new HostAddressFactory().toHostAddressList(this.cassandraSession.getAllHosts());
        BigInteger start = BigInteger.valueOf(Long.MIN_VALUE);
        BigInteger end = BigInteger.valueOf(Long.MAX_VALUE);
        BigInteger one = BigInteger.valueOf(1L);
        BigInteger splits = BigInteger.valueOf(this.unpartitionedSplits);
        long delta = end.subtract(start).subtract(one).divide(splits).longValue();
        long startToken = start.longValue();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < this.unpartitionedSplits - 1; ++i) {
            long endToken = startToken + delta;
            String condition = CassandraSplitManager.buildTokenCondition(tokenExpression, startToken, endToken);
            CassandraSplit split = new CassandraSplit(this.connectorId, schema, tableName, partitionId, condition, addresses);
            builder.add((Object)split);
            startToken = endToken + 1L;
        }
        String condition = CassandraSplitManager.buildTokenCondition(tokenExpression, startToken, end.longValue());
        CassandraSplit split = new CassandraSplit(this.connectorId, schema, tableName, partitionId, condition, addresses);
        builder.add((Object)split);
        return builder.build();
    }

    private static String buildTokenCondition(String tokenExpression, long startToken, long endToken) {
        return tokenExpression + " >= " + startToken + " AND " + tokenExpression + " <= " + endToken;
    }

    private List<Split> getSplitsForPartitions(CassandraTableHandle cassTableHandle, List<Partition> partitions) {
        String schema = cassTableHandle.getSchemaName();
        String table = cassTableHandle.getTableName();
        HostAddressFactory hostAddressFactory = new HostAddressFactory();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Partition partition : partitions) {
            Preconditions.checkArgument((boolean)(partition instanceof CassandraPartition), (Object)"partitions are no CassandraPartitions");
            CassandraPartition cassandraPartition = (CassandraPartition)partition;
            Set<Host> hosts = this.cassandraSession.getReplicas(schema, cassandraPartition.getKeyAsByteBuffer());
            List<HostAddress> addresses = hostAddressFactory.toHostAddressList(hosts);
            CassandraSplit split = new CassandraSplit(this.connectorId, schema, table, cassandraPartition.getPartitionId(), null, addresses);
            builder.add((Object)split);
        }
        return builder.build();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("clientId", (Object)this.connectorId).toString();
    }

    public static Predicate<CassandraPartition> partitionMatches(final TupleDomain tupleDomain) {
        return new Predicate<CassandraPartition>(){

            public boolean apply(CassandraPartition partition) {
                return tupleDomain.overlaps(partition.getTupleDomain());
            }
        };
    }
}

