/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraColumnHandle;
import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.cassandra.util.CassandraCqlUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class CassandraTable {
    private final CassandraTableHandle tableHandle;
    private final List<CassandraColumnHandle> columns;
    private final int partitionKeyColumns;

    public CassandraTable(CassandraTableHandle tableHandle, List<CassandraColumnHandle> columns) {
        int count;
        this.tableHandle = tableHandle;
        this.columns = ImmutableList.copyOf(columns);
        for (count = 0; count < columns.size() && columns.get(count).isPartitionKey(); ++count) {
        }
        this.partitionKeyColumns = count;
    }

    public List<CassandraColumnHandle> getColumns() {
        return this.columns;
    }

    public CassandraTableHandle getTableHandle() {
        return this.tableHandle;
    }

    public List<CassandraColumnHandle> getPartitionKeyColumns() {
        return this.columns.subList(0, this.partitionKeyColumns);
    }

    public String getTokenExpression() {
        StringBuilder sb = new StringBuilder();
        for (CassandraColumnHandle column : this.getPartitionKeyColumns()) {
            if (sb.length() == 0) {
                sb.append("token(");
            } else {
                sb.append(",");
            }
            sb.append(CassandraCqlUtils.validColumnName(column.getName()));
        }
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        return this.tableHandle.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CassandraTable)) {
            return false;
        }
        CassandraTable that = (CassandraTable)obj;
        return this.tableHandle.equals(that.tableHandle);
    }
}

