/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class RetryDriver {
    private static final Logger log = Logger.get(RetryDriver.class);
    private static final int DEFAULT_RETRY_ATTEMPTS = 10;
    private static final Duration DEFAULT_SLEEP_TIME = Duration.valueOf((String)"1s");
    private static final Duration DEFAULT_MAX_RETRY_TIME = Duration.valueOf((String)"30s");
    private final int maxRetryAttempts;
    private final Duration sleepTime;
    private final Duration maxRetryTime;
    private final List<Class<? extends Exception>> exceptionWhiteList;

    private RetryDriver(int maxRetryAttempts, Duration sleepTime, Duration maxRetryTime, List<Class<? extends Exception>> exceptionWhiteList) {
        this.maxRetryAttempts = maxRetryAttempts;
        this.sleepTime = sleepTime;
        this.maxRetryTime = maxRetryTime;
        this.exceptionWhiteList = exceptionWhiteList;
    }

    private RetryDriver() {
        this(10, DEFAULT_SLEEP_TIME, DEFAULT_MAX_RETRY_TIME, (List<Class<? extends Exception>>)ImmutableList.of());
    }

    public static RetryDriver retry() {
        return new RetryDriver();
    }

    @SafeVarargs
    public final RetryDriver stopOn(Class<? extends Exception> ... classes) {
        Preconditions.checkNotNull(classes, (Object)"classes is null");
        ImmutableList exceptions = ImmutableList.builder().addAll(this.exceptionWhiteList).addAll(Arrays.asList(classes)).build();
        return new RetryDriver(this.maxRetryAttempts, this.sleepTime, this.maxRetryTime, (List<Class<? extends Exception>>)exceptions);
    }

    public RetryDriver stopOnIllegalExceptions() {
        return this.stopOn(NullPointerException.class, IllegalStateException.class, IllegalArgumentException.class);
    }

    public <V> V run(String callableName, Callable<V> callable) throws Exception {
        Preconditions.checkNotNull((Object)callableName, (Object)"callableName is null");
        Preconditions.checkNotNull(callable, (Object)"callable is null");
        long startTime = System.nanoTime();
        int attempt = 0;
        while (true) {
            ++attempt;
            try {
                return callable.call();
            }
            catch (Exception e) {
                for (Class<? extends Exception> clazz : this.exceptionWhiteList) {
                    if (!clazz.isInstance(e)) continue;
                    throw e;
                }
                if (attempt >= this.maxRetryAttempts || Duration.nanosSince((long)startTime).compareTo(this.maxRetryTime) >= 0) {
                    throw e;
                }
                log.debug("Failed on executing %s with attempt %d, will retry. Exception: %s", new Object[]{callableName, attempt, e.getMessage()});
                TimeUnit.MILLISECONDS.sleep(this.sleepTime.toMillis());
                continue;
            }
            break;
        }
    }
}

