/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.List;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpContentResponse;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpRequestException;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;

public class ContinueProtocolHandler
implements ProtocolHandler {
    private static final String ATTRIBUTE = ContinueProtocolHandler.class.getName() + ".100continue";
    private final HttpClient client;
    private final ResponseNotifier notifier;

    public ContinueProtocolHandler(HttpClient client) {
        this.client = client;
        this.notifier = new ResponseNotifier(client);
    }

    @Override
    public boolean accept(Request request, Response response) {
        boolean expect100 = request.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
        HttpConversation conversation = ((HttpRequest)request).getConversation();
        boolean handled100 = conversation.getAttribute(ATTRIBUTE) != null;
        return expect100 && !handled100;
    }

    @Override
    public Response.Listener getResponseListener() {
        return new ContinueListener();
    }

    protected class ContinueListener
    extends BufferingResponseListener {
        protected ContinueListener() {
        }

        @Override
        public void onSuccess(Response response) {
            HttpConversation conversation = ((HttpRequest)response.getRequest()).getConversation();
            conversation.setAttribute(ATTRIBUTE, Boolean.TRUE);
            conversation.updateResponseListeners(null);
            HttpExchange exchange = conversation.getExchanges().peekLast();
            assert (exchange.getResponse() == response);
            switch (response.getStatus()) {
                case 100: {
                    exchange.resetResponse(true);
                    exchange.proceed(null);
                    break;
                }
                default: {
                    List<Response.ResponseListener> listeners = exchange.getResponseListeners();
                    HttpContentResponse contentResponse = new HttpContentResponse(response, this.getContent(), this.getEncoding());
                    ContinueProtocolHandler.this.notifier.forwardSuccess(listeners, contentResponse);
                    exchange.proceed(new HttpRequestException("Expectation failed", exchange.getRequest()));
                    break;
                }
            }
        }

        @Override
        public void onFailure(Response response, Throwable failure) {
            HttpConversation conversation = ((HttpRequest)response.getRequest()).getConversation();
            conversation.setAttribute(ATTRIBUTE, Boolean.TRUE);
            conversation.updateResponseListeners(null);
            HttpExchange exchange = conversation.getExchanges().peekLast();
            assert (exchange.getResponse() == response);
            List<Response.ResponseListener> listeners = exchange.getResponseListeners();
            HttpContentResponse contentResponse = new HttpContentResponse(response, this.getContent(), this.getEncoding());
            ContinueProtocolHandler.this.notifier.forwardFailureComplete(listeners, exchange.getRequest(), exchange.getRequestFailure(), contentResponse, failure);
        }

        @Override
        public void onComplete(Result result) {
        }
    }
}

