/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Preconditions;

public class Cast
extends Expression {
    private final Expression expression;
    private final String type;

    public Cast(Expression expression, String type) {
        Preconditions.checkNotNull((Object)expression, (Object)"expression is null");
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        this.expression = expression;
        this.type = type.toUpperCase();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCast(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cast cast = (Cast)o;
        if (!this.expression.equals(cast.expression)) {
            return false;
        }
        return this.type.equals(cast.type);
    }

    @Override
    public int hashCode() {
        int result = this.expression.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }
}

