/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBooleanParser;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.NumberParser;
import com.facebook.presto.hive.shaded.org.apache.commons.codec.binary.Base64;
import com.facebook.presto.hive.util.SerDeUtils;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.RecordCursor;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.mapred.RecordReader;

class ColumnarTextHiveRecordCursor<K>
implements RecordCursor {
    private final RecordReader<K, BytesRefArrayWritable> recordReader;
    private final K key;
    private final BytesRefArrayWritable value;
    private final String[] names;
    private final ColumnType[] types;
    private final HiveType[] hiveTypes;
    private final ObjectInspector[] fieldInspectors;
    private final int[] hiveColumnIndexes;
    private final boolean[] isPartitionColumn;
    private final boolean[] loaded;
    private final boolean[] booleans;
    private final long[] longs;
    private final double[] doubles;
    private final byte[][] strings;
    private final boolean[] nulls;
    private final long totalBytes;
    private long completedBytes;
    private boolean closed;

    public ColumnarTextHiveRecordCursor(RecordReader<K, BytesRefArrayWritable> recordReader, long totalBytes, Properties splitSchema, List<HivePartitionKey> partitionKeys, List<HiveColumnHandle> columns) {
        HiveColumnHandle column;
        Preconditions.checkNotNull(recordReader, (Object)"recordReader is null");
        Preconditions.checkArgument((totalBytes >= 0L ? 1 : 0) != 0, (Object)"totalBytes is negative");
        Preconditions.checkNotNull((Object)splitSchema, (Object)"splitSchema is null");
        Preconditions.checkNotNull(partitionKeys, (Object)"partitionKeys is null");
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (Object)"columns is empty");
        this.recordReader = recordReader;
        this.totalBytes = totalBytes;
        this.key = recordReader.createKey();
        this.value = (BytesRefArrayWritable)recordReader.createValue();
        int size = columns.size();
        this.names = new String[size];
        this.types = new ColumnType[size];
        this.hiveTypes = new HiveType[size];
        this.fieldInspectors = new ObjectInspector[size];
        this.hiveColumnIndexes = new int[size];
        this.isPartitionColumn = new boolean[size];
        this.loaded = new boolean[size];
        this.booleans = new boolean[size];
        this.longs = new long[size];
        this.doubles = new double[size];
        this.strings = new byte[size][];
        this.nulls = new boolean[size];
        try {
            StructObjectInspector rowInspector = HiveUtil.getTableObjectInspector(splitSchema);
            for (int i = 0; i < columns.size(); ++i) {
                column = columns.get(i);
                this.names[i] = column.getName();
                this.types[i] = column.getType();
                this.hiveTypes[i] = column.getHiveType();
                if (!column.isPartitionKey()) {
                    this.fieldInspectors[i] = rowInspector.getStructFieldRef(column.getName()).getFieldObjectInspector();
                }
                this.hiveColumnIndexes[i] = column.getHiveColumnIndex();
                this.isPartitionColumn[i] = column.isPartitionKey();
            }
        }
        catch (RuntimeException | MetaException | SerDeException e) {
            throw Throwables.propagate((Throwable)e);
        }
        ImmutableMap partitionKeysByName = Maps.uniqueIndex(partitionKeys, HivePartitionKey.nameGetter());
        block9: for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            column = columns.get(columnIndex);
            if (!column.isPartitionKey()) continue;
            HivePartitionKey partitionKey = (HivePartitionKey)partitionKeysByName.get(column.getName());
            Preconditions.checkArgument((partitionKey != null ? 1 : 0) != 0, (String)"Unknown partition key %s", (Object[])new Object[]{column.getName()});
            byte[] bytes = partitionKey.getValue().getBytes(Charsets.UTF_8);
            switch (this.types[columnIndex]) {
                case BOOLEAN: {
                    if (HiveBooleanParser.isTrue(bytes, 0, bytes.length)) {
                        this.booleans[columnIndex] = true;
                        continue block9;
                    }
                    if (HiveBooleanParser.isFalse(bytes, 0, bytes.length)) {
                        this.booleans[columnIndex] = false;
                        continue block9;
                    }
                    String valueString = new String(bytes, Charsets.UTF_8);
                    throw new IllegalArgumentException(String.format("Invalid partition value '%s' for BOOLEAN partition key %s", valueString, this.names[columnIndex]));
                }
                case LONG: {
                    if (bytes.length == 0) {
                        throw new IllegalArgumentException(String.format("Invalid partition value '' for BIGINT partition key %s", this.names[columnIndex]));
                    }
                    this.longs[columnIndex] = NumberParser.parseLong(bytes, 0, bytes.length);
                    continue block9;
                }
                case DOUBLE: {
                    if (bytes.length == 0) {
                        throw new IllegalArgumentException(String.format("Invalid partition value '' for DOUBLE partition key %s", this.names[columnIndex]));
                    }
                    this.doubles[columnIndex] = NumberParser.parseDouble(bytes, 0, bytes.length);
                    continue block9;
                }
                case STRING: {
                    this.strings[columnIndex] = Arrays.copyOf(bytes, bytes.length);
                    continue block9;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported column type: " + this.types[columnIndex]);
                }
            }
        }
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getCompletedBytes() {
        if (!this.closed) {
            this.updateCompletedBytes();
        }
        return this.completedBytes;
    }

    private void updateCompletedBytes() {
        try {
            long newCompletedBytes = (long)((float)this.totalBytes * this.recordReader.getProgress());
            this.completedBytes = Math.min(this.totalBytes, Math.max(this.completedBytes, newCompletedBytes));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ColumnType getType(int field) {
        return this.types[field];
    }

    public boolean advanceNextPosition() {
        try {
            if (this.closed || !this.recordReader.next(this.key, (Object)this.value)) {
                this.close();
                return false;
            }
            System.arraycopy(this.isPartitionColumn, 0, this.loaded, 0, this.isPartitionColumn.length);
            Arrays.fill(this.nulls, false);
            return true;
        }
        catch (IOException | RuntimeException e) {
            this.close();
            throw Throwables.propagate((Throwable)e);
        }
    }

    public boolean getBoolean(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, ColumnType.BOOLEAN);
        if (!this.loaded[fieldId]) {
            this.parseBooleanColumn(fieldId);
        }
        return this.booleans[fieldId];
    }

    private void parseBooleanColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        if (this.hiveColumnIndexes[column] >= this.value.size()) {
            this.nulls[column] = true;
        } else {
            byte[] bytes;
            BytesRefWritable fieldData = this.value.unCheckedGet(this.hiveColumnIndexes[column]);
            try {
                bytes = fieldData.getData();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            int start = fieldData.getStart();
            int length = fieldData.getLength();
            this.parseBooleanColumn(column, bytes, start, length);
        }
    }

    private void parseBooleanColumn(int column, byte[] bytes, int start, int length) {
        boolean wasNull;
        if (HiveBooleanParser.isTrue(bytes, start, length)) {
            this.booleans[column] = true;
            wasNull = false;
        } else if (HiveBooleanParser.isFalse(bytes, start, length)) {
            this.booleans[column] = false;
            wasNull = false;
        } else {
            wasNull = true;
        }
        this.nulls[column] = wasNull;
    }

    public long getLong(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, ColumnType.LONG);
        if (!this.loaded[fieldId]) {
            this.parseLongColumn(fieldId);
        }
        return this.longs[fieldId];
    }

    private void parseLongColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        if (this.hiveColumnIndexes[column] >= this.value.size()) {
            this.nulls[column] = true;
        } else {
            byte[] bytes;
            BytesRefWritable fieldData = this.value.unCheckedGet(this.hiveColumnIndexes[column]);
            try {
                bytes = fieldData.getData();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            int start = fieldData.getStart();
            int length = fieldData.getLength();
            this.parseLongColumn(column, bytes, start, length);
        }
    }

    private void parseLongColumn(int column, byte[] bytes, int start, int length) {
        boolean wasNull;
        if (length == 0 || length == "\\N".length() && bytes[start] == 92 && bytes[start + 1] == 78) {
            wasNull = true;
        } else if (this.hiveTypes[column] == HiveType.TIMESTAMP) {
            String value = new String(bytes, start, length);
            this.longs[column] = HiveUtil.parseHiveTimestamp(value);
            wasNull = false;
        } else {
            this.longs[column] = NumberParser.parseLong(bytes, start, length);
            wasNull = false;
        }
        this.nulls[column] = wasNull;
    }

    public double getDouble(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, ColumnType.DOUBLE);
        if (!this.loaded[fieldId]) {
            this.parseDoubleColumn(fieldId);
        }
        return this.doubles[fieldId];
    }

    private void parseDoubleColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        if (this.hiveColumnIndexes[column] >= this.value.size()) {
            this.nulls[column] = true;
        } else {
            byte[] bytes;
            BytesRefWritable fieldData = this.value.unCheckedGet(this.hiveColumnIndexes[column]);
            try {
                bytes = fieldData.getData();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            int start = fieldData.getStart();
            int length = fieldData.getLength();
            this.parseDoubleColumn(column, bytes, start, length);
        }
    }

    private void parseDoubleColumn(int column, byte[] bytes, int start, int length) {
        boolean wasNull;
        if (length == 0 || length == "\\N".length() && bytes[start] == 92 && bytes[start + 1] == 78) {
            wasNull = true;
        } else {
            this.doubles[column] = NumberParser.parseDouble(bytes, start, length);
            wasNull = false;
        }
        this.nulls[column] = wasNull;
    }

    public byte[] getString(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, ColumnType.STRING);
        if (!this.loaded[fieldId]) {
            this.parseStringColumn(fieldId);
        }
        return this.strings[fieldId];
    }

    private void parseStringColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        if (this.hiveColumnIndexes[column] >= this.value.size()) {
            this.nulls[column] = true;
        } else {
            byte[] bytes;
            BytesRefWritable fieldData = this.value.unCheckedGet(this.hiveColumnIndexes[column]);
            try {
                bytes = fieldData.getData();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            int start = fieldData.getStart();
            int length = fieldData.getLength();
            this.parseStringColumn(column, bytes, start, length);
        }
    }

    private void parseStringColumn(int column, byte[] bytes, int start, int length) {
        boolean wasNull;
        if (length == "\\N".length() && bytes[start] == 92 && bytes[start + 1] == 78) {
            wasNull = true;
        } else if (this.hiveTypes[column] == HiveType.MAP || this.hiveTypes[column] == HiveType.LIST || this.hiveTypes[column] == HiveType.STRUCT) {
            LazyObject lazyObject = LazyFactory.createLazyObject((ObjectInspector)this.fieldInspectors[column]);
            ByteArrayRef byteArrayRef = new ByteArrayRef();
            byteArrayRef.setData(bytes);
            lazyObject.init(byteArrayRef, start, length);
            this.strings[column] = SerDeUtils.getJsonBytes(lazyObject.getObject(), this.fieldInspectors[column]);
            wasNull = false;
        } else {
            this.strings[column] = Arrays.copyOfRange(bytes, start, start + length);
            if (this.hiveTypes[column] == HiveType.BINARY) {
                this.strings[column] = Base64.decodeBase64((byte[])this.strings[column]);
            }
            wasNull = false;
        }
        this.nulls[column] = wasNull;
    }

    public boolean isNull(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        if (!this.loaded[fieldId]) {
            this.parseColumn(fieldId);
        }
        return this.nulls[fieldId];
    }

    private void parseColumn(int column) {
        switch (this.types[column]) {
            case BOOLEAN: {
                this.parseBooleanColumn(column);
                break;
            }
            case LONG: {
                this.parseLongColumn(column);
                break;
            }
            case DOUBLE: {
                this.parseDoubleColumn(column);
                break;
            }
            case STRING: {
                this.parseStringColumn(column);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported column type: " + this.types[column]);
            }
        }
    }

    private void validateType(int fieldId, ColumnType type) {
        if (this.types[fieldId] != type) {
            throw new IllegalArgumentException(String.format("Expected field to be %s, actual %s (field %s)", type, this.types[fieldId], fieldId));
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.updateCompletedBytes();
        try {
            this.recordReader.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

