/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.ColumnarTextHiveRecordCursor;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.spi.RecordCursor;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.mapred.RecordReader;

public class ColumnarTextHiveRecordCursorProvider
implements HiveRecordCursorProvider {
    @Override
    public Optional<RecordCursor> createHiveRecordCursor(HiveSplit split, RecordReader<?, ?> recordReader, List<HiveColumnHandle> columns) {
        if (ColumnarTextHiveRecordCursorProvider.usesColumnarTextSerDe(split)) {
            return Optional.of(new ColumnarTextHiveRecordCursor(ColumnarTextHiveRecordCursorProvider.columnarTextRecordReader(recordReader), split.getLength(), split.getSchema(), split.getPartitionKeys(), columns));
        }
        return Optional.absent();
    }

    private static boolean usesColumnarTextSerDe(HiveSplit split) {
        try {
            return MetaStoreUtils.getDeserializer(null, (Properties)split.getSchema()) instanceof ColumnarSerDe;
        }
        catch (MetaException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static RecordReader<?, BytesRefArrayWritable> columnarTextRecordReader(RecordReader<?, ?> recordReader) {
        return recordReader;
    }
}

