/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveClient;
import com.facebook.presto.hive.HiveClientModule;
import com.facebook.presto.hive.HiveConnector;
import com.facebook.presto.hive.RebindSafeMBeanServer;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorOutputHandleResolver;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.classloader.ClassLoaderSafeConnectorHandleResolver;
import com.facebook.presto.spi.classloader.ClassLoaderSafeConnectorMetadata;
import com.facebook.presto.spi.classloader.ClassLoaderSafeConnectorOutputHandleResolver;
import com.facebook.presto.spi.classloader.ClassLoaderSafeConnectorRecordSetProvider;
import com.facebook.presto.spi.classloader.ClassLoaderSafeConnectorRecordSinkProvider;
import com.facebook.presto.spi.classloader.ClassLoaderSafeConnectorSplitManager;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.discovery.client.DiscoveryModule;
import io.airlift.json.JsonModule;
import io.airlift.node.NodeModule;
import java.lang.management.ManagementFactory;
import java.util.Map;
import javax.management.MBeanServer;
import org.weakref.jmx.guice.MBeanModule;

public class HiveConnectorFactory
implements ConnectorFactory {
    private final String name;
    private final Map<String, String> optionalConfig;
    private final ClassLoader classLoader;

    public HiveConnectorFactory(String name, Map<String, String> optionalConfig, ClassLoader classLoader) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.optionalConfig = (Map)Preconditions.checkNotNull(optionalConfig, (Object)"optionalConfig is null");
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader is null");
    }

    public String getName() {
        return this.name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connector create(String connectorId, Map<String, String> config) {
        Preconditions.checkNotNull(config, (Object)"config is null");
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new NodeModule(), new DiscoveryModule(), new MBeanModule(), new JsonModule(), new HiveClientModule(connectorId), new Module(){

                public void configure(Binder binder) {
                    MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
                    binder.bind(MBeanServer.class).toInstance((Object)new RebindSafeMBeanServer(platformMBeanServer));
                }
            }});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).setOptionalConfigurationProperties(this.optionalConfig).initialize();
            HiveClient hiveClient = (HiveClient)injector.getInstance(HiveClient.class);
            HiveConnector hiveConnector = new HiveConnector((ConnectorMetadata)new ClassLoaderSafeConnectorMetadata((ConnectorMetadata)hiveClient, this.classLoader), (ConnectorSplitManager)new ClassLoaderSafeConnectorSplitManager((ConnectorSplitManager)hiveClient, this.classLoader), (ConnectorRecordSetProvider)new ClassLoaderSafeConnectorRecordSetProvider((ConnectorRecordSetProvider)hiveClient, this.classLoader), (ConnectorRecordSinkProvider)new ClassLoaderSafeConnectorRecordSinkProvider((ConnectorRecordSinkProvider)hiveClient, this.classLoader), (ConnectorHandleResolver)new ClassLoaderSafeConnectorHandleResolver((ConnectorHandleResolver)hiveClient, this.classLoader), (ConnectorOutputHandleResolver)new ClassLoaderSafeConnectorOutputHandleResolver((ConnectorOutputHandleResolver)hiveClient, this.classLoader));
            return hiveConnector;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

