/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveType;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.PartitionKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class HivePartitionKey
implements PartitionKey {
    private final String name;
    private final HiveType hiveType;
    private final String value;

    @JsonCreator
    public HivePartitionKey(@JsonProperty(value="name") String name, @JsonProperty(value="hiveType") HiveType hiveType, @JsonProperty(value="value") String value) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull((Object)((Object)hiveType), (Object)"hiveType is null");
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        this.name = name;
        this.hiveType = hiveType;
        this.value = value;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public HiveType getHiveType() {
        return this.hiveType;
    }

    public ColumnType getType() {
        return this.hiveType.getNativeType();
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("hiveType", (Object)this.hiveType).add("value", (Object)this.value).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.hiveType, this.value});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HivePartitionKey other = (HivePartitionKey)obj;
        return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)((Object)this.hiveType), (Object)((Object)other.hiveType)) && Objects.equal((Object)this.value, (Object)other.value);
    }

    public static Function<HivePartitionKey, String> nameGetter() {
        return new Function<HivePartitionKey, String>(){

            public String apply(HivePartitionKey input) {
                return input.getName();
            }
        };
    }
}

