/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveOutputTableHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.spi.RecordSink;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public class HiveRecordSink
implements RecordSink {
    private final int fieldCount;
    private final Serializer serializer;
    private final FileSinkOperator.RecordWriter recordWriter;
    private final SettableStructObjectInspector tableInspector;
    private final List<StructField> structFields;
    private final Object row;
    private final int sampleWeightField;
    private int field = -1;

    public HiveRecordSink(HiveOutputTableHandle handle, Path target, JobConf conf) {
        this.fieldCount = handle.getColumnNames().size();
        this.sampleWeightField = handle.getColumnNames().indexOf("__presto__sample_weight__");
        Iterable hiveTypes = Iterables.transform(handle.getColumnTypes(), HiveType.columnTypeToHiveType());
        Iterable hiveTypeNames = Iterables.transform((Iterable)hiveTypes, HiveType.hiveTypeNameGetter());
        Properties properties = new Properties();
        properties.setProperty("columns", Joiner.on((char)',').join(handle.getColumnNames()));
        properties.setProperty("columns.types", Joiner.on((char)':').join(hiveTypeNames));
        this.serializer = HiveRecordSink.initializeSerializer((Configuration)conf, properties, (Serializer)new LazyBinaryColumnarSerDe());
        this.recordWriter = HiveRecordSink.createRecordWriter(target, conf, properties, new RCFileOutputFormat());
        this.tableInspector = ObjectInspectorFactory.getStandardStructObjectInspector(handle.getColumnNames(), HiveRecordSink.getJavaObjectInspectors(hiveTypes));
        this.structFields = ImmutableList.copyOf((Collection)this.tableInspector.getAllStructFieldRefs());
        this.row = this.tableInspector.create();
    }

    public void beginRecord(long sampleWeight) {
        Preconditions.checkState((this.field == -1 ? 1 : 0) != 0, (Object)"already in record");
        if (this.sampleWeightField >= 0) {
            this.tableInspector.setStructFieldData(this.row, this.structFields.get(this.sampleWeightField), (Object)sampleWeight);
        }
        this.field = 0;
        if (this.sampleWeightField == 0) {
            ++this.field;
        }
    }

    public void finishRecord() {
        Preconditions.checkState((this.field != -1 ? 1 : 0) != 0, (Object)"not in record");
        Preconditions.checkState((this.field == this.fieldCount ? 1 : 0) != 0, (Object)"not all fields set");
        this.field = -1;
        try {
            this.recordWriter.write(this.serializer.serialize(this.row, (ObjectInspector)this.tableInspector));
        }
        catch (IOException | SerDeException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void appendNull() {
        this.append(null);
    }

    public void appendBoolean(boolean value) {
        this.append(value);
    }

    public void appendLong(long value) {
        this.append(value);
    }

    public void appendDouble(double value) {
        this.append(value);
    }

    public void appendString(byte[] value) {
        this.append(new String(value, StandardCharsets.UTF_8));
    }

    public String commit() {
        Preconditions.checkState((this.field == -1 ? 1 : 0) != 0, (Object)"record not finished");
        try {
            this.recordWriter.close(false);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return "";
    }

    private void append(Object value) {
        Preconditions.checkState((this.field != -1 ? 1 : 0) != 0, (Object)"not in record");
        Preconditions.checkState((this.field < this.fieldCount ? 1 : 0) != 0, (Object)"all fields already set");
        this.tableInspector.setStructFieldData(this.row, this.structFields.get(this.field), value);
        ++this.field;
        if (this.field == this.sampleWeightField) {
            ++this.field;
        }
    }

    private static Serializer initializeSerializer(Configuration conf, Properties properties, Serializer serializer) {
        try {
            serializer.initialize(conf, properties);
        }
        catch (SerDeException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return serializer;
    }

    private static FileSinkOperator.RecordWriter createRecordWriter(Path target, JobConf conf, Properties properties, HiveOutputFormat<?, ?> outputFormat) {
        try {
            return outputFormat.getHiveRecordWriter(conf, target, Text.class, false, properties, (Progressable)Reporter.NULL);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static List<ObjectInspector> getJavaObjectInspectors(Iterable<HiveType> hiveTypes) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (HiveType type : hiveTypes) {
            list.add((Object)HiveRecordSink.getJavaObjectInspector(type));
        }
        return list.build();
    }

    private static PrimitiveObjectInspector getJavaObjectInspector(HiveType type) {
        switch (type) {
            case BOOLEAN: {
                return PrimitiveObjectInspectorFactory.javaBooleanObjectInspector;
            }
            case LONG: {
                return PrimitiveObjectInspectorFactory.javaLongObjectInspector;
            }
            case DOUBLE: {
                return PrimitiveObjectInspectorFactory.javaDoubleObjectInspector;
            }
            case STRING: {
                return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
            }
        }
        throw new IllegalArgumentException("unsupported type: " + (Object)((Object)type));
    }
}

