/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.spi.ColumnType;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

public enum HiveType {
    BOOLEAN(ColumnType.BOOLEAN),
    BYTE(ColumnType.LONG),
    SHORT(ColumnType.LONG),
    INT(ColumnType.LONG),
    LONG(ColumnType.LONG),
    FLOAT(ColumnType.DOUBLE),
    DOUBLE(ColumnType.DOUBLE),
    STRING(ColumnType.STRING),
    TIMESTAMP(ColumnType.LONG),
    BINARY(ColumnType.STRING),
    LIST(ColumnType.STRING),
    MAP(ColumnType.STRING),
    STRUCT(ColumnType.STRING);

    private final ColumnType nativeType;
    private static final BiMap<String, HiveType> HIVE_TYPE_NAMES;

    private HiveType(ColumnType nativeType) {
        this.nativeType = (ColumnType)Preconditions.checkNotNull((Object)nativeType, (Object)"nativeType is null");
    }

    public ColumnType getNativeType() {
        return this.nativeType;
    }

    public String getHiveTypeName() {
        return (String)HIVE_TYPE_NAMES.inverse().get((Object)this);
    }

    public static HiveType getSupportedHiveType(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        HiveType hiveType = HiveType.getHiveType(primitiveCategory);
        Preconditions.checkArgument((hiveType != null ? 1 : 0) != 0, (Object)("Unknown primitive Hive category: " + primitiveCategory));
        return hiveType;
    }

    public static HiveType getHiveType(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        switch (primitiveCategory) {
            case BOOLEAN: {
                return BOOLEAN;
            }
            case BYTE: {
                return BYTE;
            }
            case SHORT: {
                return SHORT;
            }
            case INT: {
                return INT;
            }
            case LONG: {
                return LONG;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case STRING: {
                return STRING;
            }
            case TIMESTAMP: {
                return TIMESTAMP;
            }
            case BINARY: {
                return BINARY;
            }
        }
        return null;
    }

    public static HiveType getSupportedHiveType(String hiveTypeName) {
        HiveType hiveType = HiveType.getHiveType(hiveTypeName);
        Preconditions.checkArgument((hiveType != null ? 1 : 0) != 0, (Object)("Unknown Hive type: " + hiveTypeName));
        return hiveType;
    }

    public static HiveType getHiveType(String hiveTypeName) {
        return (HiveType)((Object)HIVE_TYPE_NAMES.get((Object)hiveTypeName));
    }

    public static HiveType getSupportedHiveType(ObjectInspector fieldInspector) {
        HiveType hiveType = HiveType.getHiveType(fieldInspector);
        Preconditions.checkArgument((hiveType != null ? 1 : 0) != 0, (Object)("Unknown Hive category: " + fieldInspector.getCategory()));
        return hiveType;
    }

    public static HiveType getHiveType(ObjectInspector fieldInspector) {
        switch (fieldInspector.getCategory()) {
            case PRIMITIVE: {
                return HiveType.getHiveType(((PrimitiveObjectInspector)fieldInspector).getPrimitiveCategory());
            }
            case MAP: {
                return MAP;
            }
            case LIST: {
                return LIST;
            }
            case STRUCT: {
                return STRUCT;
            }
        }
        return null;
    }

    public static HiveType toHiveType(ColumnType type) {
        switch (type) {
            case BOOLEAN: {
                return BOOLEAN;
            }
            case LONG: {
                return LONG;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case STRING: {
                return STRING;
            }
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    public static Function<ColumnType, HiveType> columnTypeToHiveType() {
        return new Function<ColumnType, HiveType>(){

            public HiveType apply(ColumnType type) {
                return HiveType.toHiveType(type);
            }
        };
    }

    public static Function<HiveType, String> hiveTypeNameGetter() {
        return new Function<HiveType, String>(){

            public String apply(HiveType type) {
                return type.getHiveTypeName();
            }
        };
    }

    static {
        HIVE_TYPE_NAMES = ImmutableBiMap.builder().put((Object)"boolean", (Object)BOOLEAN).put((Object)"tinyint", (Object)BYTE).put((Object)"smallint", (Object)SHORT).put((Object)"int", (Object)INT).put((Object)"bigint", (Object)LONG).put((Object)"float", (Object)FLOAT).put((Object)"double", (Object)DOUBLE).put((Object)"string", (Object)STRING).put((Object)"timestamp", (Object)TIMESTAMP).put((Object)"binary", (Object)BINARY).put((Object)"array", (Object)LIST).put((Object)"map", (Object)MAP).put((Object)"struct", (Object)STRUCT).build();
    }
}

