/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.io.BytesWritable;

public final class SerDeUtils {
    private SerDeUtils() {
    }

    public static byte[] getJsonBytes(Object object, ObjectInspector objectInspector) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (JsonGenerator generator = new JsonFactory().createGenerator((OutputStream)out);){
            SerDeUtils.buildJsonString(generator, object, objectInspector);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return out.toByteArray();
    }

    private static String getPrimitiveAsString(Object object, PrimitiveObjectInspector objectInspector) {
        if (object == null) {
            return null;
        }
        switch (objectInspector.getPrimitiveCategory()) {
            case BOOLEAN: {
                return Boolean.toString(((BooleanObjectInspector)objectInspector).get(object));
            }
            case BYTE: {
                return Byte.toString(((ByteObjectInspector)objectInspector).get(object));
            }
            case SHORT: {
                return Short.toString(((ShortObjectInspector)objectInspector).get(object));
            }
            case INT: {
                return Integer.toString(((IntObjectInspector)objectInspector).get(object));
            }
            case LONG: {
                return Long.toString(((LongObjectInspector)objectInspector).get(object));
            }
            case FLOAT: {
                return Float.toString(((FloatObjectInspector)objectInspector).get(object));
            }
            case DOUBLE: {
                return Double.toString(((DoubleObjectInspector)objectInspector).get(object));
            }
            case STRING: {
                return ((StringObjectInspector)objectInspector).getPrimitiveJavaObject(object);
            }
            case TIMESTAMP: {
                return String.valueOf(((TimestampObjectInspector)objectInspector).getPrimitiveWritableObject(object).getSeconds());
            }
            case BINARY: {
                BytesWritable writable = ((BinaryObjectInspector)objectInspector).getPrimitiveWritableObject(object);
                return Base64Variants.getDefaultVariant().encode(Arrays.copyOf(writable.getBytes(), writable.getLength()));
            }
        }
        throw new RuntimeException("Unknown primitive type: " + objectInspector.getPrimitiveCategory());
    }

    private static void buildJsonString(JsonGenerator generator, Object object, ObjectInspector objectInspector) throws IOException {
        block0 : switch (objectInspector.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector primitiveObjectInspector = (PrimitiveObjectInspector)objectInspector;
                if (object == null) {
                    generator.writeNull();
                    break;
                }
                switch (primitiveObjectInspector.getPrimitiveCategory()) {
                    case BOOLEAN: {
                        generator.writeBoolean(((BooleanObjectInspector)primitiveObjectInspector).get(object));
                        break block0;
                    }
                    case BYTE: {
                        generator.writeNumber((int)((ByteObjectInspector)primitiveObjectInspector).get(object));
                        break block0;
                    }
                    case SHORT: {
                        generator.writeNumber((int)((ShortObjectInspector)primitiveObjectInspector).get(object));
                        break block0;
                    }
                    case INT: {
                        generator.writeNumber(((IntObjectInspector)primitiveObjectInspector).get(object));
                        break block0;
                    }
                    case LONG: {
                        generator.writeNumber(((LongObjectInspector)primitiveObjectInspector).get(object));
                        break block0;
                    }
                    case FLOAT: {
                        generator.writeNumber(((FloatObjectInspector)primitiveObjectInspector).get(object));
                        break block0;
                    }
                    case DOUBLE: {
                        generator.writeNumber(((DoubleObjectInspector)primitiveObjectInspector).get(object));
                        break block0;
                    }
                    case STRING: {
                        generator.writeString(((StringObjectInspector)primitiveObjectInspector).getPrimitiveJavaObject(object));
                        break block0;
                    }
                    case TIMESTAMP: {
                        generator.writeNumber(((TimestampObjectInspector)primitiveObjectInspector).getPrimitiveWritableObject(object).getSeconds());
                        break block0;
                    }
                    case BINARY: {
                        generator.writeBinary(((BinaryObjectInspector)objectInspector).getPrimitiveJavaObject(object));
                        break block0;
                    }
                }
                throw new RuntimeException("Unknown primitive type: " + primitiveObjectInspector.getPrimitiveCategory());
            }
            case LIST: {
                ListObjectInspector listInspector = (ListObjectInspector)objectInspector;
                List objectList = listInspector.getList(object);
                if (objectList == null) {
                    generator.writeNull();
                    break;
                }
                generator.writeStartArray();
                ObjectInspector elementInspector = listInspector.getListElementObjectInspector();
                for (Object element : objectList) {
                    SerDeUtils.buildJsonString(generator, element, elementInspector);
                }
                generator.writeEndArray();
                break;
            }
            case MAP: {
                MapObjectInspector mapInspector = (MapObjectInspector)objectInspector;
                Map objectMap = mapInspector.getMap(object);
                if (objectMap == null) {
                    generator.writeNull();
                    break;
                }
                generator.writeStartObject();
                ObjectInspector keyInspector = mapInspector.getMapKeyObjectInspector();
                Preconditions.checkState((boolean)(keyInspector instanceof PrimitiveObjectInspector));
                ObjectInspector valueInspector = mapInspector.getMapValueObjectInspector();
                for (Map.Entry entry : objectMap.entrySet()) {
                    generator.writeFieldName(SerDeUtils.getPrimitiveAsString(entry.getKey(), (PrimitiveObjectInspector)keyInspector));
                    SerDeUtils.buildJsonString(generator, entry.getValue(), valueInspector);
                }
                generator.writeEndObject();
                break;
            }
            case STRUCT: {
                if (object == null) {
                    generator.writeNull();
                    break;
                }
                generator.writeStartObject();
                StructObjectInspector structInspector = (StructObjectInspector)objectInspector;
                List structFields = structInspector.getAllStructFieldRefs();
                for (int i = 0; i < structFields.size(); ++i) {
                    generator.writeFieldName(((StructField)structFields.get(i)).getFieldName());
                    SerDeUtils.buildJsonString(generator, structInspector.getStructFieldData(object, (StructField)structFields.get(i)), ((StructField)structFields.get(i)).getFieldObjectInspector());
                }
                generator.writeEndObject();
                break;
            }
            case UNION: {
                if (object == null) {
                    generator.writeNull();
                    break;
                }
                generator.writeStartObject();
                UnionObjectInspector unionInspector = (UnionObjectInspector)objectInspector;
                generator.writeFieldName(Byte.toString(unionInspector.getTag(object)));
                SerDeUtils.buildJsonString(generator, unionInspector.getField(object), (ObjectInspector)unionInspector.getObjectInspectors().get(unionInspector.getTag(object)));
                generator.writeEndObject();
                break;
            }
            default: {
                throw new RuntimeException("Unknown type in ObjectInspector!" + objectInspector.getCategory());
            }
        }
    }
}

