/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.store;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.fasterxml.jackson.dataformat.smile.SmileParser;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/x-jackson-smile"})
@Produces(value={"application/x-jackson-smile"})
public class SmileMapper
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    public static final Validator VALIDATOR = Validation.buildDefaultValidatorFactory().getValidator();
    private static final ImmutableSet<Class<?>> IO_CLASSES = ImmutableSet.builder().add(InputStream.class).add(Reader.class).add(OutputStream.class).add(Writer.class).add(byte[].class).add(char[].class).add(StreamingOutput.class).add(Response.class).build();
    public static final Logger log = Logger.get(SmileMapper.class);
    private final ObjectMapper objectMapper;

    @Inject
    public SmileMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.canReadOrWrite(type);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.canReadOrWrite(type);
    }

    private boolean canReadOrWrite(Class<?> type) {
        if (IO_CLASSES.contains(type)) {
            return false;
        }
        for (Class ioClass : IO_CLASSES) {
            if (!ioClass.isAssignableFrom(type)) continue;
            return false;
        }
        return true;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream inputStream) throws IOException {
        Object object;
        try {
            SmileParser jsonParser = new SmileFactory().createParser(inputStream);
            jsonParser.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            object = this.objectMapper.readValue((JsonParser)jsonParser, this.objectMapper.getTypeFactory().constructType(genericType));
        }
        catch (Exception e) {
            if (e instanceof IOException && !(e instanceof JsonProcessingException) && !(e instanceof EOFException)) {
                throw (IOException)e;
            }
            log.debug((Throwable)e, "Invalid json for Java type %s", new Object[]{type});
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Invalid json for Java type " + type)).build());
        }
        Set violations = VALIDATOR.validate(object, new Class[0]);
        if (!violations.isEmpty()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(SmileMapper.messagesFor(violations)).build());
        }
        return object;
    }

    public long getSize(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream outputStream) throws IOException {
        SmileGenerator jsonGenerator = new SmileFactory().createGenerator(outputStream);
        jsonGenerator.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        JavaType rootType = null;
        if (genericType != null && value != null && genericType.getClass() != Class.class && (rootType = this.objectMapper.getTypeFactory().constructType(genericType)).getRawClass() == Object.class) {
            rootType = null;
        }
        if (rootType != null) {
            this.objectMapper.writerWithType(rootType).writeValue((JsonGenerator)jsonGenerator, value);
        } else {
            this.objectMapper.writeValue((JsonGenerator)jsonGenerator, value);
        }
    }

    private static List<String> messagesFor(Collection<? extends ConstraintViolation<?>> violations) {
        ImmutableList.Builder messages = new ImmutableList.Builder();
        for (ConstraintViolation<?> violation : violations) {
            messages.add((Object)(violation.getPropertyPath().toString() + " " + violation.getMessage()));
        }
        return messages.build();
    }
}

