/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.ColumnType;
import java.util.Objects;

public class ColumnMetadata {
    private final String name;
    private final ColumnType type;
    private final int ordinalPosition;
    private final boolean partitionKey;

    public ColumnMetadata(String name, ColumnType type, int ordinalPosition, boolean partitionKey) {
        if (name == null || name.isEmpty()) {
            throw new NullPointerException("name is null or empty");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (ordinalPosition < 0) {
            throw new IllegalArgumentException("ordinalPosition is negative");
        }
        this.name = name.toLowerCase();
        this.type = type;
        this.ordinalPosition = ordinalPosition;
        this.partitionKey = partitionKey;
    }

    public String getName() {
        return this.name;
    }

    public ColumnType getType() {
        return this.type;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public boolean isPartitionKey() {
        return this.partitionKey;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ColumnMetadata{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", type=").append((Object)this.type);
        sb.append(", ordinalPosition=").append(this.ordinalPosition);
        sb.append(", partitionKey=").append(this.partitionKey);
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.ordinalPosition, this.partitionKey});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnMetadata other = (ColumnMetadata)obj;
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.ordinalPosition, other.ordinalPosition) && Objects.equals(this.partitionKey, other.partitionKey);
    }
}

