/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class InMemoryRecordSet
implements RecordSet {
    private final List<ColumnType> types;
    private final Iterable<? extends List<?>> records;
    private final long totalBytes;

    public InMemoryRecordSet(Collection<ColumnType> types, Collection<? extends List<?>> records) {
        this.types = Collections.unmodifiableList(new ArrayList<ColumnType>(types));
        this.records = records;
        long totalBytes = 0L;
        for (List<?> record : records) {
            totalBytes += InMemoryRecordSet.sizeOf(record);
        }
        this.totalBytes = totalBytes;
    }

    @Override
    public List<ColumnType> getColumnTypes() {
        return this.types;
    }

    @Override
    public RecordCursor cursor() {
        return new InMemoryRecordCursor(this.types, this.records.iterator(), this.totalBytes);
    }

    public static Builder builder(ConnectorTableMetadata tableMetadata) {
        return InMemoryRecordSet.builder(tableMetadata.getColumns());
    }

    public static Builder builder(List<ColumnMetadata> columns) {
        ArrayList<ColumnType> columnTypes = new ArrayList<ColumnType>();
        for (ColumnMetadata column : columns) {
            columnTypes.add(column.getType());
        }
        return InMemoryRecordSet.builder(columnTypes);
    }

    public static Builder builder(Collection<ColumnType> columnsTypes) {
        return new Builder(columnsTypes);
    }

    private static void checkArgument(boolean test, String message, Object ... args) {
        if (!test) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    private static void checkNotNull(Object value, String message) {
        if (value == null) {
            throw new NullPointerException(message);
        }
    }

    private static void checkState(boolean test, String message) {
        if (!test) {
            throw new IllegalStateException(message);
        }
    }

    private static long sizeOf(List<?> record) {
        long completedBytes = 0L;
        for (Object value : record) {
            if (value instanceof Boolean) {
                ++completedBytes;
                continue;
            }
            if (value instanceof Long) {
                completedBytes += 8L;
                continue;
            }
            if (value instanceof Double) {
                completedBytes += 8L;
                continue;
            }
            if (value instanceof String) {
                completedBytes += (long)((String)value).length();
                continue;
            }
            if (!(value instanceof byte[])) continue;
            completedBytes += (long)((byte[])value).length;
        }
        return completedBytes;
    }

    public static class Builder {
        private final List<ColumnType> types;
        private final List<List<Object>> records = new ArrayList<List<Object>>();

        private Builder(Collection<ColumnType> types) {
            InMemoryRecordSet.checkNotNull(types, "types is null");
            this.types = Collections.unmodifiableList(new ArrayList<ColumnType>(types));
            InMemoryRecordSet.checkArgument(!this.types.isEmpty(), "types is empty", new Object[0]);
        }

        public Builder addRow(Object ... values) {
            InMemoryRecordSet.checkNotNull(values, "values is null");
            InMemoryRecordSet.checkArgument(values.length == this.types.size(), "Expected %s values in row, but got %s values", new Object[]{this.types.size(), values.length});
            block6: for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                if (value == null) continue;
                switch (this.types.get(i)) {
                    case BOOLEAN: {
                        InMemoryRecordSet.checkArgument(value instanceof Boolean, "Expected value %d to be an instance of Boolean, but is a %s", new Object[]{i, value.getClass().getSimpleName()});
                        continue block6;
                    }
                    case LONG: {
                        InMemoryRecordSet.checkArgument(value instanceof Long, "Expected value %d to be an instance of Long, but is a %s", new Object[]{i, value.getClass().getSimpleName()});
                        continue block6;
                    }
                    case DOUBLE: {
                        InMemoryRecordSet.checkArgument(value instanceof Double, "Expected value %d to be an instance of Double, but is a %s", new Object[]{i, value.getClass().getSimpleName()});
                        continue block6;
                    }
                    case STRING: {
                        InMemoryRecordSet.checkArgument(value instanceof String || value instanceof byte[], "Expected value %d to be an instance of String or byte[], but is a %s", new Object[]{i, value.getClass().getSimpleName()});
                        continue block6;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported column type " + (Object)((Object)this.types.get(i)));
                    }
                }
            }
            this.records.add(Collections.unmodifiableList(new ArrayList<Object>(Arrays.asList(values))));
            return this;
        }

        public InMemoryRecordSet build() {
            return new InMemoryRecordSet(this.types, this.records);
        }
    }

    private static class InMemoryRecordCursor
    implements RecordCursor {
        private final List<ColumnType> types;
        private final Iterator<? extends List<?>> records;
        private final long totalBytes;
        private List<?> record;
        private long completedBytes;

        private InMemoryRecordCursor(List<ColumnType> types, Iterator<? extends List<?>> records, long totalBytes) {
            this.types = types;
            this.records = records;
            this.totalBytes = totalBytes;
        }

        @Override
        public long getTotalBytes() {
            return this.totalBytes;
        }

        @Override
        public long getCompletedBytes() {
            return this.completedBytes;
        }

        @Override
        public ColumnType getType(int field) {
            return this.types.get(field);
        }

        @Override
        public boolean advanceNextPosition() {
            if (!this.records.hasNext()) {
                this.record = null;
                return false;
            }
            this.record = this.records.next();
            this.completedBytes += InMemoryRecordSet.sizeOf(this.record);
            return true;
        }

        @Override
        public boolean getBoolean(int field) {
            InMemoryRecordSet.checkState(this.record != null, "no current record");
            InMemoryRecordSet.checkNotNull(this.record.get(field), "value is null");
            return (Boolean)this.record.get(field);
        }

        @Override
        public long getLong(int field) {
            InMemoryRecordSet.checkState(this.record != null, "no current record");
            InMemoryRecordSet.checkNotNull(this.record.get(field), "value is null");
            return (Long)this.record.get(field);
        }

        @Override
        public double getDouble(int field) {
            InMemoryRecordSet.checkState(this.record != null, "no current record");
            InMemoryRecordSet.checkNotNull(this.record.get(field), "value is null");
            return (Double)this.record.get(field);
        }

        @Override
        public byte[] getString(int field) {
            InMemoryRecordSet.checkState(this.record != null, "no current record");
            Object value = this.record.get(field);
            InMemoryRecordSet.checkNotNull(value, "value is null");
            if (value instanceof byte[]) {
                return (byte[])value;
            }
            if (value instanceof String) {
                return ((String)value).getBytes(StandardCharsets.UTF_8);
            }
            throw new IllegalArgumentException("Field " + field + " is not a String, but is a " + value.getClass().getName());
        }

        @Override
        public boolean isNull(int field) {
            InMemoryRecordSet.checkState(this.record != null, "no current record");
            return this.record.get(field) == null;
        }

        @Override
        public void close() {
        }
    }
}

