/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.ErrorCode;

public enum StandardErrorCode {
    USER_ERROR(0),
    SYNTAX_ERROR(1),
    ABANDONED_QUERY(2),
    USER_CANCELED(3),
    CANNOT_DROP_TABLE(4),
    NOT_FOUND(5),
    FUNCTION_NOT_FOUND(6),
    INVALID_FUNCTION_ARGUMENT(7),
    DIVISION_BY_ZERO(8),
    INTERNAL(65536),
    TOO_MANY_REQUESTS_FAILED(65537),
    INSUFFICIENT_RESOURCES(131072),
    EXCEEDED_MEMORY_LIMIT(131073),
    EXTERNAL(0x1000000);

    private final ErrorCode errorCode;

    private StandardErrorCode(int code) {
        this.errorCode = new ErrorCode(code, this.name());
    }

    public ErrorCode toErrorCode() {
        return this.errorCode;
    }

    public static ErrorType toErrorType(int code) {
        if (code < INTERNAL.toErrorCode().getCode()) {
            return ErrorType.USER_ERROR;
        }
        if (code < INSUFFICIENT_RESOURCES.toErrorCode().getCode()) {
            return ErrorType.INTERNAL;
        }
        if (code < EXTERNAL.toErrorCode().getCode()) {
            return ErrorType.INSUFFICIENT_RESOURCES;
        }
        return ErrorType.EXTERNAL;
    }

    public static enum ErrorType {
        USER_ERROR,
        INTERNAL,
        INSUFFICIENT_RESOURCES,
        EXTERNAL;

    }
}

