/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.classloader;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.OutputTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ClassLoaderSafeConnectorMetadata
implements ConnectorMetadata {
    private final ConnectorMetadata delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorMetadata(ConnectorMetadata delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public boolean canHandle(TableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.canHandle(tableHandle);
            return bl;
        }
    }

    @Override
    public List<String> listSchemaNames() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List<String> list = this.delegate.listSchemaNames();
            return list;
        }
    }

    @Override
    public TableHandle getTableHandle(SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            TableHandle tableHandle = this.delegate.getTableHandle(tableName);
            return tableHandle;
        }
    }

    @Override
    public ConnectorTableMetadata getTableMetadata(TableHandle table) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableMetadata connectorTableMetadata = this.delegate.getTableMetadata(table);
            return connectorTableMetadata;
        }
    }

    @Override
    public List<SchemaTableName> listTables(String schemaNameOrNull) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List<SchemaTableName> list = this.delegate.listTables(schemaNameOrNull);
            return list;
        }
    }

    @Override
    public ColumnHandle getColumnHandle(TableHandle tableHandle, String columnName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ColumnHandle columnHandle = this.delegate.getColumnHandle(tableHandle, columnName);
            return columnHandle;
        }
    }

    @Override
    public ColumnHandle getSampleWeightColumnHandle(TableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ColumnHandle columnHandle = this.delegate.getSampleWeightColumnHandle(tableHandle);
            return columnHandle;
        }
    }

    @Override
    public boolean canCreateSampledTables() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.canCreateSampledTables();
            return bl;
        }
    }

    @Override
    public Map<String, ColumnHandle> getColumnHandles(TableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Map<String, ColumnHandle> map = this.delegate.getColumnHandles(tableHandle);
            return map;
        }
    }

    @Override
    public ColumnMetadata getColumnMetadata(TableHandle tableHandle, ColumnHandle columnHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ColumnMetadata columnMetadata = this.delegate.getColumnMetadata(tableHandle, columnHandle);
            return columnMetadata;
        }
    }

    @Override
    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(SchemaTablePrefix prefix) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Map<SchemaTableName, List<ColumnMetadata>> map = this.delegate.listTableColumns(prefix);
            return map;
        }
    }

    @Override
    public TableHandle createTable(ConnectorTableMetadata tableMetadata) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            TableHandle tableHandle = this.delegate.createTable(tableMetadata);
            return tableHandle;
        }
    }

    @Override
    public void dropTable(TableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.dropTable(tableHandle);
        }
    }

    @Override
    public boolean canHandle(OutputTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.canHandle(tableHandle);
            return bl;
        }
    }

    @Override
    public OutputTableHandle beginCreateTable(ConnectorTableMetadata tableMetadata) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            OutputTableHandle outputTableHandle = this.delegate.beginCreateTable(tableMetadata);
            return outputTableHandle;
        }
    }

    @Override
    public void commitCreateTable(OutputTableHandle tableHandle, Collection<String> fragments) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.commitCreateTable(tableHandle, fragments);
        }
    }

    public String toString() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.toString();
            return string;
        }
    }
}

