/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.classloader;

import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.PartitionResult;
import com.facebook.presto.spi.SplitSource;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import java.util.List;
import java.util.Objects;

public final class ClassLoaderSafeConnectorSplitManager
implements ConnectorSplitManager {
    private final ConnectorSplitManager delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorSplitManager(ConnectorSplitManager delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public String getConnectorId() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.getConnectorId();
            return string;
        }
    }

    @Override
    public boolean canHandle(TableHandle handle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.canHandle(handle);
            return bl;
        }
    }

    @Override
    public PartitionResult getPartitions(TableHandle table, TupleDomain tupleDomain) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            PartitionResult partitionResult = this.delegate.getPartitions(table, tupleDomain);
            return partitionResult;
        }
    }

    @Override
    public SplitSource getPartitionSplits(TableHandle table, List<Partition> partitions) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            SplitSource splitSource = this.delegate.getPartitionSplits(table, partitions);
            return splitSource;
        }
    }

    public String toString() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.toString();
            return string;
        }
    }
}

