/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.BackgroundCacheLoader;
import com.facebook.presto.hive.CachingHiveMetastoreStats;
import com.facebook.presto.hive.ForHiveMetastore;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveCluster;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveMetastoreClient;
import com.facebook.presto.hive.HiveViewNotSupportedException;
import com.facebook.presto.hive.RetryDriver;
import com.facebook.presto.hive.TableAlreadyExistsException;
import com.facebook.presto.hive.shaded.org.apache.thrift.TException;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

@ThreadSafe
public class CachingHiveMetastore {
    private final CachingHiveMetastoreStats stats = new CachingHiveMetastoreStats();
    protected final HiveCluster clientProvider;
    private final LoadingCache<String, List<String>> databaseNamesCache;
    private final LoadingCache<String, Database> databaseCache;
    private final LoadingCache<String, List<String>> tableNamesCache;
    private final LoadingCache<HiveTableName, List<String>> partitionNamesCache;
    private final LoadingCache<HiveTableName, Table> tableCache;
    private final LoadingCache<HivePartitionName, Partition> partitionCache;
    private final LoadingCache<PartitionFilter, List<String>> partitionFilterCache;

    @Inject
    public CachingHiveMetastore(HiveCluster hiveCluster, @ForHiveMetastore ExecutorService executor, HiveClientConfig hiveClientConfig) {
        this((HiveCluster)Preconditions.checkNotNull((Object)hiveCluster, (Object)"hiveCluster is null"), (ExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor is null"), ((HiveClientConfig)Preconditions.checkNotNull((Object)hiveClientConfig, (Object)"hiveClientConfig is null")).getMetastoreCacheTtl(), hiveClientConfig.getMetastoreRefreshInterval());
    }

    public CachingHiveMetastore(HiveCluster hiveCluster, ExecutorService executor, Duration cacheTtl, Duration refreshInterval) {
        this.clientProvider = (HiveCluster)Preconditions.checkNotNull((Object)hiveCluster, (Object)"hiveCluster is null");
        long expiresAfterWriteMillis = ((Duration)Preconditions.checkNotNull((Object)cacheTtl, (Object)"cacheTtl is null")).toMillis();
        long refreshMills = ((Duration)Preconditions.checkNotNull((Object)refreshInterval, (Object)"refreshInterval is null")).toMillis();
        ListeningExecutorService listeningExecutor = MoreExecutors.listeningDecorator((ExecutorService)executor);
        this.databaseNamesCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build((CacheLoader)new BackgroundCacheLoader<String, List<String>>(listeningExecutor){

            public List<String> load(String key) throws Exception {
                return CachingHiveMetastore.this.loadAllDatabases();
            }
        });
        this.databaseCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build((CacheLoader)new BackgroundCacheLoader<String, Database>(listeningExecutor){

            public Database load(String databaseName) throws Exception {
                return CachingHiveMetastore.this.loadDatabase(databaseName);
            }
        });
        this.tableNamesCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build((CacheLoader)new BackgroundCacheLoader<String, List<String>>(listeningExecutor){

            public List<String> load(String databaseName) throws Exception {
                return CachingHiveMetastore.this.loadAllTables(databaseName);
            }
        });
        this.tableCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build((CacheLoader)new BackgroundCacheLoader<HiveTableName, Table>(listeningExecutor){

            public Table load(HiveTableName hiveTableName) throws Exception {
                return CachingHiveMetastore.this.loadTable(hiveTableName);
            }
        });
        this.partitionNamesCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build((CacheLoader)new BackgroundCacheLoader<HiveTableName, List<String>>(listeningExecutor){

            public List<String> load(HiveTableName hiveTableName) throws Exception {
                return CachingHiveMetastore.this.loadPartitionNames(hiveTableName);
            }
        });
        this.partitionFilterCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build((CacheLoader)new BackgroundCacheLoader<PartitionFilter, List<String>>(listeningExecutor){

            public List<String> load(PartitionFilter partitionFilter) throws Exception {
                return CachingHiveMetastore.this.loadPartitionNamesByParts(partitionFilter);
            }
        });
        this.partitionCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build((CacheLoader)new BackgroundCacheLoader<HivePartitionName, Partition>(listeningExecutor){

            public Partition load(HivePartitionName partitionName) throws Exception {
                return CachingHiveMetastore.this.loadPartitionByName(partitionName);
            }

            public Map<HivePartitionName, Partition> loadAll(Iterable<? extends HivePartitionName> partitionNames) throws Exception {
                return CachingHiveMetastore.this.loadPartitionsByNames(partitionNames);
            }
        });
    }

    @Managed
    @Flatten
    public CachingHiveMetastoreStats getStats() {
        return this.stats;
    }

    @Managed
    public void flushCache() {
        this.databaseNamesCache.invalidateAll();
        this.tableNamesCache.invalidateAll();
        this.partitionNamesCache.invalidateAll();
        this.databaseCache.invalidateAll();
        this.tableCache.invalidateAll();
        this.partitionCache.invalidateAll();
        this.partitionFilterCache.invalidateAll();
    }

    private static <K, V, E extends Exception> V get(LoadingCache<K, V> cache, K key, Class<E> exceptionClass) throws E {
        try {
            return (V)cache.get(key);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable t = e.getCause();
            Throwables.propagateIfInstanceOf((Throwable)t, exceptionClass);
            throw Throwables.propagate((Throwable)t);
        }
    }

    private static <K, V, E extends Exception> Map<K, V> getAll(LoadingCache<K, V> cache, Iterable<K> keys, Class<E> exceptionClass) throws E {
        try {
            return cache.getAll(keys);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable t = e.getCause();
            Throwables.propagateIfInstanceOf((Throwable)t, exceptionClass);
            throw Throwables.propagate((Throwable)t);
        }
    }

    public List<String> getAllDatabases() {
        return CachingHiveMetastore.get(this.databaseNamesCache, "", RuntimeException.class);
    }

    private List<String> loadAllDatabases() throws Exception {
        try {
            return RetryDriver.retry().stopOnIllegalExceptions().run("getAllDatabases", this.stats.getGetAllDatabases().wrap(new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    try (HiveMetastoreClient client = CachingHiveMetastore.this.clientProvider.createMetastoreClient();){
                        List list = client.get_all_databases();
                        return list;
                    }
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException(HiveErrorCode.HIVE_METASTORE_ERROR.toErrorCode(), (Throwable)e);
        }
    }

    public Database getDatabase(String databaseName) throws NoSuchObjectException {
        return CachingHiveMetastore.get(this.databaseCache, databaseName, NoSuchObjectException.class);
    }

    private Database loadDatabase(final String databaseName) throws Exception {
        try {
            return RetryDriver.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getDatabase", this.stats.getGetDatabase().wrap(new Callable<Database>(){

                @Override
                public Database call() throws Exception {
                    try (HiveMetastoreClient client = CachingHiveMetastore.this.clientProvider.createMetastoreClient();){
                        Database database = client.get_database(databaseName);
                        return database;
                    }
                }
            }));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (TException e) {
            throw new PrestoException(HiveErrorCode.HIVE_METASTORE_ERROR.toErrorCode(), (Throwable)e);
        }
    }

    public List<String> getAllTables(String databaseName) throws NoSuchObjectException {
        return CachingHiveMetastore.get(this.tableNamesCache, databaseName, NoSuchObjectException.class);
    }

    private List<String> loadAllTables(final String databaseName) throws Exception {
        final Callable<List<String>> getAllTables = this.stats.getGetAllTables().wrap(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                try (HiveMetastoreClient client = CachingHiveMetastore.this.clientProvider.createMetastoreClient();){
                    List list = client.get_all_tables(databaseName);
                    return list;
                }
            }
        });
        final Callable<Void> getDatabase = this.stats.getGetDatabase().wrap(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (HiveMetastoreClient client = CachingHiveMetastore.this.clientProvider.createMetastoreClient();){
                    client.get_database(databaseName);
                    Void void_ = null;
                    return void_;
                }
            }
        });
        try {
            return RetryDriver.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getAllTables", new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    List tables = (List)getAllTables.call();
                    if (tables.isEmpty()) {
                        getDatabase.call();
                    }
                    return tables;
                }
            });
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (TException e) {
            throw new PrestoException(HiveErrorCode.HIVE_METASTORE_ERROR.toErrorCode(), (Throwable)e);
        }
    }

    public Table getTable(String databaseName, String tableName) throws NoSuchObjectException {
        return CachingHiveMetastore.get(this.tableCache, HiveTableName.table(databaseName, tableName), NoSuchObjectException.class);
    }

    public void createTable(final Table table) {
        try {
            RetryDriver.retry().stopOn(AlreadyExistsException.class, InvalidObjectException.class, MetaException.class, NoSuchObjectException.class).stopOnIllegalExceptions().run("createTable", this.stats.getCreateTable().wrap(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try (HiveMetastoreClient client = CachingHiveMetastore.this.clientProvider.createMetastoreClient();){
                        client.create_table(table);
                    }
                    return null;
                }
            }));
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException(new SchemaTableName(table.getDbName(), table.getTableName()));
        }
        catch (InvalidObjectException | MetaException | NoSuchObjectException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (TException e) {
            throw new PrestoException(HiveErrorCode.HIVE_METASTORE_ERROR.toErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void dropTable(final String databaseName, final String tableName) {
        try {
            RetryDriver.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("dropTable", this.stats.getDropTable().wrap(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try (HiveMetastoreClient client = CachingHiveMetastore.this.clientProvider.createMetastoreClient();){
                        client.drop_table(databaseName, tableName, true);
                    }
                    return null;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (TException e) {
            throw new PrestoException(HiveErrorCode.HIVE_METASTORE_ERROR.toErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Table loadTable(final HiveTableName hiveTableName) throws Exception {
        try {
            return RetryDriver.retry().stopOn(NoSuchObjectException.class, HiveViewNotSupportedException.class).stopOnIllegalExceptions().run("getTable", this.stats.getGetTable().wrap(new Callable<Table>(){

                @Override
                public Table call() throws Exception {
                    try (HiveMetastoreClient client = CachingHiveMetastore.this.clientProvider.createMetastoreClient();){
                        Table table = client.get_table(hiveTableName.getDatabaseName(), hiveTableName.getTableName());
                        if (table.getTableType().equals(TableType.VIRTUAL_VIEW.toString())) {
                            throw new HiveViewNotSupportedException(new SchemaTableName(hiveTableName.getDatabaseName(), hiveTableName.getTableName()));
                        }
                        Table table2 = table;
                        return table2;
                    }
                }
            }));
        }
        catch (HiveViewNotSupportedException | NoSuchObjectException e) {
            throw e;
        }
        catch (TException e) {
            throw new PrestoException(HiveErrorCode.HIVE_METASTORE_ERROR.toErrorCode(), (Throwable)e);
        }
    }

    public List<String> getPartitionNames(String databaseName, String tableName) throws NoSuchObjectException {
        return CachingHiveMetastore.get(this.partitionNamesCache, HiveTableName.table(databaseName, tableName), NoSuchObjectException.class);
    }

    private List<String> loadPartitionNames(final HiveTableName hiveTableName) throws Exception {
        try {
            return RetryDriver.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionNames", this.stats.getGetPartitionNames().wrap(new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    try (HiveMetastoreClient client = CachingHiveMetastore.this.clientProvider.createMetastoreClient();){
                        List list = client.get_partition_names(hiveTableName.getDatabaseName(), hiveTableName.getTableName(), (short)0);
                        return list;
                    }
                }
            }));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (TException e) {
            throw new PrestoException(HiveErrorCode.HIVE_METASTORE_ERROR.toErrorCode(), (Throwable)e);
        }
    }

    public List<String> getPartitionNamesByParts(String databaseName, String tableName, List<String> parts) throws NoSuchObjectException {
        return CachingHiveMetastore.get(this.partitionFilterCache, PartitionFilter.partitionFilter(databaseName, tableName, parts), NoSuchObjectException.class);
    }

    private List<String> loadPartitionNamesByParts(final PartitionFilter partitionFilter) throws Exception {
        try {
            return RetryDriver.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionNamesByParts", this.stats.getGetPartitionNamesPs().wrap(new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    try (HiveMetastoreClient client = CachingHiveMetastore.this.clientProvider.createMetastoreClient();){
                        List list = client.get_partition_names_ps(partitionFilter.getHiveTableName().getDatabaseName(), partitionFilter.getHiveTableName().getTableName(), partitionFilter.getParts(), (short)-1);
                        return list;
                    }
                }
            }));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (TException e) {
            throw new PrestoException(HiveErrorCode.HIVE_METASTORE_ERROR.toErrorCode(), (Throwable)e);
        }
    }

    public List<Partition> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) throws NoSuchObjectException {
        Iterable names = Iterables.transform(partitionNames, CachingHiveMetastore.partitionNameCreator(databaseName, tableName));
        return ImmutableList.copyOf(CachingHiveMetastore.getAll(this.partitionCache, names, NoSuchObjectException.class).values());
    }

    private Partition loadPartitionByName(final HivePartitionName partitionName) throws Exception {
        Preconditions.checkNotNull((Object)partitionName, (Object)"partitionName is null");
        try {
            return RetryDriver.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionsByNames", this.stats.getGetPartitionByName().wrap(new Callable<Partition>(){

                @Override
                public Partition call() throws Exception {
                    try (HiveMetastoreClient client = CachingHiveMetastore.this.clientProvider.createMetastoreClient();){
                        Partition partition = client.get_partition_by_name(partitionName.getHiveTableName().getDatabaseName(), partitionName.getHiveTableName().getTableName(), partitionName.getPartitionName());
                        return partition;
                    }
                }
            }));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (TException e) {
            throw new PrestoException(HiveErrorCode.HIVE_METASTORE_ERROR.toErrorCode(), (Throwable)e);
        }
    }

    private Map<HivePartitionName, Partition> loadPartitionsByNames(Iterable<? extends HivePartitionName> partitionNames) throws Exception {
        Preconditions.checkNotNull(partitionNames, (Object)"partitionNames is null");
        Preconditions.checkArgument((!Iterables.isEmpty(partitionNames) ? 1 : 0) != 0, (Object)"partitionNames is empty");
        HivePartitionName firstPartition = (HivePartitionName)Iterables.get(partitionNames, (int)0);
        HiveTableName hiveTableName = firstPartition.getHiveTableName();
        final String databaseName = hiveTableName.getDatabaseName();
        final String tableName = hiveTableName.getTableName();
        final ArrayList<String> partitionsToFetch = new ArrayList<String>();
        for (HivePartitionName hivePartitionName : partitionNames) {
            Preconditions.checkArgument((boolean)hivePartitionName.getHiveTableName().equals(hiveTableName), (String)"Expected table name %s but got %s", (Object[])new Object[]{hiveTableName, hivePartitionName.getHiveTableName()});
            partitionsToFetch.add(hivePartitionName.getPartitionName());
        }
        ImmutableList partitionColumnNames = ImmutableList.copyOf(Warehouse.makeSpecFromName((String)firstPartition.getPartitionName()).keySet());
        try {
            return RetryDriver.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionsByNames", this.stats.getGetPartitionsByNames().wrap(new Callable<Map<HivePartitionName, Partition>>((List)partitionColumnNames){
                final /* synthetic */ List val$partitionColumnNames;
                {
                    this.val$partitionColumnNames = list2;
                }

                @Override
                public Map<HivePartitionName, Partition> call() throws Exception {
                    try (HiveMetastoreClient client = CachingHiveMetastore.this.clientProvider.createMetastoreClient();){
                        ImmutableMap.Builder partitions = ImmutableMap.builder();
                        for (Partition partition : client.get_partitions_by_names(databaseName, tableName, partitionsToFetch)) {
                            String partitionId = FileUtils.makePartName((List)this.val$partitionColumnNames, (List)partition.getValues(), null);
                            partitions.put((Object)HivePartitionName.partition(databaseName, tableName, partitionId), (Object)partition);
                        }
                        ImmutableMap immutableMap = partitions.build();
                        return immutableMap;
                    }
                }
            }));
        }
        catch (NoSuchObjectException noSuchObjectException) {
            throw noSuchObjectException;
        }
        catch (TException tException) {
            throw new PrestoException(HiveErrorCode.HIVE_METASTORE_ERROR.toErrorCode(), (Throwable)tException);
        }
    }

    private static Function<String, HivePartitionName> partitionNameCreator(final String databaseName, final String tableName) {
        return new Function<String, HivePartitionName>(){

            public HivePartitionName apply(String partitionName) {
                return HivePartitionName.partition(databaseName, tableName, partitionName);
            }
        };
    }

    private static class PartitionFilter {
        private final HiveTableName hiveTableName;
        private final List<String> parts;

        private PartitionFilter(HiveTableName hiveTableName, List<String> parts) {
            this.hiveTableName = hiveTableName;
            this.parts = ImmutableList.copyOf(parts);
        }

        public static PartitionFilter partitionFilter(String databaseName, String tableName, List<String> parts) {
            return new PartitionFilter(HiveTableName.table(databaseName, tableName), parts);
        }

        public HiveTableName getHiveTableName() {
            return this.hiveTableName;
        }

        public List<String> getParts() {
            return this.parts;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("hiveTableName", (Object)this.hiveTableName).add("parts", this.parts).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionFilter that = (PartitionFilter)o;
            return Objects.equal((Object)this.hiveTableName, (Object)that.hiveTableName) && Objects.equal(this.parts, that.parts);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.hiveTableName, this.parts});
        }
    }

    private static class HivePartitionName {
        private final HiveTableName hiveTableName;
        private final String partitionName;

        private HivePartitionName(HiveTableName hiveTableName, String partitionName) {
            this.hiveTableName = hiveTableName;
            this.partitionName = partitionName;
        }

        public static HivePartitionName partition(String databaseName, String tableName, String partitionName) {
            return new HivePartitionName(HiveTableName.table(databaseName, tableName), partitionName);
        }

        public HiveTableName getHiveTableName() {
            return this.hiveTableName;
        }

        public String getPartitionName() {
            return this.partitionName;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("hiveTableName", (Object)this.hiveTableName).add("partitionName", (Object)this.partitionName).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HivePartitionName that = (HivePartitionName)o;
            return Objects.equal((Object)this.hiveTableName, (Object)that.hiveTableName) && Objects.equal((Object)this.partitionName, (Object)that.partitionName);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.hiveTableName, this.partitionName});
        }
    }

    private static class HiveTableName {
        private final String databaseName;
        private final String tableName;

        private HiveTableName(String databaseName, String tableName) {
            this.databaseName = databaseName;
            this.tableName = tableName;
        }

        public static HiveTableName table(String databaseName, String tableName) {
            return new HiveTableName(databaseName, tableName);
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("databaseName", (Object)this.databaseName).add("tableName", (Object)this.tableName).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HiveTableName that = (HiveTableName)o;
            return Objects.equal((Object)this.databaseName, (Object)that.databaseName) && Objects.equal((Object)this.tableName, (Object)that.tableName);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.databaseName, this.tableName});
        }
    }
}

