/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBooleanParser;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.NumberParser;
import com.facebook.presto.hive.util.SerDeUtils;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordReader;

class GenericHiveRecordCursor<K, V extends Writable>
implements RecordCursor {
    private final RecordReader<K, V> recordReader;
    private final K key;
    private final V value;
    private final Deserializer deserializer;
    private final ColumnType[] types;
    private final HiveType[] hiveTypes;
    private final StructObjectInspector rowInspector;
    private final ObjectInspector[] fieldInspectors;
    private final StructField[] structFields;
    private final boolean[] isPartitionColumn;
    private final boolean[] loaded;
    private final boolean[] booleans;
    private final long[] longs;
    private final double[] doubles;
    private final byte[][] strings;
    private final boolean[] nulls;
    private final long totalBytes;
    private long completedBytes;
    private Object rowData;
    private boolean closed;

    public GenericHiveRecordCursor(RecordReader<K, V> recordReader, long totalBytes, Properties splitSchema, List<HivePartitionKey> partitionKeys, List<HiveColumnHandle> columns) {
        Preconditions.checkNotNull(recordReader, (Object)"recordReader is null");
        Preconditions.checkArgument((totalBytes >= 0L ? 1 : 0) != 0, (Object)"totalBytes is negative");
        Preconditions.checkNotNull((Object)splitSchema, (Object)"splitSchema is null");
        Preconditions.checkNotNull(partitionKeys, (Object)"partitionKeys is null");
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (Object)"columns is empty");
        this.recordReader = recordReader;
        this.totalBytes = totalBytes;
        this.key = recordReader.createKey();
        this.value = (Writable)recordReader.createValue();
        try {
            this.deserializer = MetaStoreUtils.getDeserializer(null, (Properties)splitSchema);
            this.rowInspector = (StructObjectInspector)this.deserializer.getObjectInspector();
        }
        catch (RuntimeException | MetaException | SerDeException e) {
            throw Throwables.propagate((Throwable)e);
        }
        int size = columns.size();
        String[] names = new String[size];
        this.types = new ColumnType[size];
        this.hiveTypes = new HiveType[size];
        this.structFields = new StructField[size];
        this.fieldInspectors = new ObjectInspector[size];
        this.isPartitionColumn = new boolean[size];
        this.loaded = new boolean[size];
        this.booleans = new boolean[size];
        this.longs = new long[size];
        this.doubles = new double[size];
        this.strings = new byte[size][];
        this.nulls = new boolean[size];
        for (int i = 0; i < columns.size(); ++i) {
            HiveColumnHandle column = columns.get(i);
            names[i] = column.getName();
            this.types[i] = column.getType();
            this.hiveTypes[i] = column.getHiveType();
            if (!column.isPartitionKey()) {
                StructField field;
                this.structFields[i] = field = this.rowInspector.getStructFieldRef(column.getName());
                this.fieldInspectors[i] = field.getFieldObjectInspector();
            }
            this.isPartitionColumn[i] = column.isPartitionKey();
        }
        ImmutableMap partitionKeysByName = Maps.uniqueIndex(partitionKeys, HivePartitionKey.nameGetter());
        block9: for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            HiveColumnHandle column = columns.get(columnIndex);
            if (!column.isPartitionKey()) continue;
            HivePartitionKey partitionKey = (HivePartitionKey)partitionKeysByName.get(column.getName());
            Preconditions.checkArgument((partitionKey != null ? 1 : 0) != 0, (String)"Unknown partition key %s", (Object[])new Object[]{column.getName()});
            byte[] bytes = partitionKey.getValue().getBytes(Charsets.UTF_8);
            switch (this.types[columnIndex]) {
                case BOOLEAN: {
                    if (HiveBooleanParser.isTrue(bytes, 0, bytes.length)) {
                        this.booleans[columnIndex] = true;
                        continue block9;
                    }
                    if (HiveBooleanParser.isFalse(bytes, 0, bytes.length)) {
                        this.booleans[columnIndex] = false;
                        continue block9;
                    }
                    String valueString = new String(bytes, Charsets.UTF_8);
                    throw new IllegalArgumentException(String.format("Invalid partition value '%s' for BOOLEAN partition key %s", valueString, names[columnIndex]));
                }
                case LONG: {
                    if (bytes.length == 0) {
                        throw new IllegalArgumentException(String.format("Invalid partition value '' for BIGINT partition key %s", names[columnIndex]));
                    }
                    this.longs[columnIndex] = NumberParser.parseLong(bytes, 0, bytes.length);
                    continue block9;
                }
                case DOUBLE: {
                    if (bytes.length == 0) {
                        throw new IllegalArgumentException(String.format("Invalid partition value '' for DOUBLE partition key %s", names[columnIndex]));
                    }
                    this.doubles[columnIndex] = NumberParser.parseDouble(bytes, 0, bytes.length);
                    continue block9;
                }
                case STRING: {
                    this.strings[columnIndex] = Arrays.copyOf(bytes, bytes.length);
                    continue block9;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported column type: " + this.types[columnIndex]);
                }
            }
        }
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getCompletedBytes() {
        if (!this.closed) {
            this.updateCompletedBytes();
        }
        return this.completedBytes;
    }

    private void updateCompletedBytes() {
        try {
            long newCompletedBytes = (long)((float)this.totalBytes * this.recordReader.getProgress());
            this.completedBytes = Math.min(this.totalBytes, Math.max(this.completedBytes, newCompletedBytes));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ColumnType getType(int field) {
        return this.types[field];
    }

    public boolean advanceNextPosition() {
        try {
            if (this.closed || !this.recordReader.next(this.key, this.value)) {
                this.close();
                return false;
            }
            System.arraycopy(this.isPartitionColumn, 0, this.loaded, 0, this.isPartitionColumn.length);
            this.rowData = this.deserializer.deserialize(this.value);
            return true;
        }
        catch (IOException | RuntimeException | SerDeException e) {
            this.close();
            throw new PrestoException(HiveErrorCode.HIVE_CURSOR_ERROR.toErrorCode(), e);
        }
    }

    public boolean getBoolean(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, ColumnType.BOOLEAN);
        if (!this.loaded[fieldId]) {
            this.parseBooleanColumn(fieldId);
        }
        return this.booleans[fieldId];
    }

    private void parseBooleanColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            Object fieldValue = ((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveJavaObject(fieldData);
            Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (Object)"fieldValue should not be null");
            this.booleans[column] = (Boolean)fieldValue;
            this.nulls[column] = false;
        }
    }

    public long getLong(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, ColumnType.LONG);
        if (!this.loaded[fieldId]) {
            this.parseLongColumn(fieldId);
        }
        return this.longs[fieldId];
    }

    private void parseLongColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            Object fieldValue = ((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveJavaObject(fieldData);
            Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (Object)"fieldValue should not be null");
            this.longs[column] = GenericHiveRecordCursor.getLongOrTimestamp(fieldValue);
            this.nulls[column] = false;
        }
    }

    private static long getLongOrTimestamp(Object value) {
        if (value instanceof Timestamp) {
            return TimeUnit.MILLISECONDS.toSeconds(((Timestamp)value).getTime());
        }
        return ((Number)value).longValue();
    }

    public double getDouble(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, ColumnType.DOUBLE);
        if (!this.loaded[fieldId]) {
            this.parseDoubleColumn(fieldId);
        }
        return this.doubles[fieldId];
    }

    private void parseDoubleColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            Object fieldValue = ((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveJavaObject(fieldData);
            Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (Object)"fieldValue should not be null");
            this.doubles[column] = ((Number)fieldValue).doubleValue();
            this.nulls[column] = false;
        }
    }

    public byte[] getString(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, ColumnType.STRING);
        if (!this.loaded[fieldId]) {
            this.parseStringColumn(fieldId);
        }
        return this.strings[fieldId];
    }

    private void parseStringColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else if (this.hiveTypes[column] == HiveType.MAP || this.hiveTypes[column] == HiveType.LIST || this.hiveTypes[column] == HiveType.STRUCT) {
            this.strings[column] = SerDeUtils.getJsonBytes(fieldData, this.fieldInspectors[column]);
            this.nulls[column] = false;
        } else {
            Object fieldValue = ((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveJavaObject(fieldData);
            Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (Object)"fieldValue should not be null");
            if (fieldValue instanceof String) {
                this.strings[column] = ((String)fieldValue).getBytes(Charsets.UTF_8);
            } else if (fieldValue instanceof byte[]) {
                this.strings[column] = (byte[])fieldValue;
            } else {
                throw new IllegalStateException("unsupported string field type: " + fieldValue.getClass().getName());
            }
            this.nulls[column] = false;
        }
    }

    public boolean isNull(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        if (!this.loaded[fieldId]) {
            this.parseColumn(fieldId);
        }
        return this.nulls[fieldId];
    }

    private void parseColumn(int column) {
        switch (this.types[column]) {
            case BOOLEAN: {
                this.parseBooleanColumn(column);
                break;
            }
            case LONG: {
                this.parseLongColumn(column);
                break;
            }
            case DOUBLE: {
                this.parseDoubleColumn(column);
                break;
            }
            case STRING: {
                this.parseStringColumn(column);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported column type: " + this.types[column]);
            }
        }
    }

    private void validateType(int fieldId, ColumnType type) {
        if (this.types[fieldId] != type) {
            throw new IllegalArgumentException(String.format("Expected field to be %s, actual %s (field %s)", type, this.types[fieldId], fieldId));
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.updateCompletedBytes();
        try {
            this.recordReader.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

