/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hadoop.HadoopFileSystemCache;
import com.facebook.presto.hadoop.HadoopNative;
import com.facebook.presto.hive.CachingHiveMetastore;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.ForHiveClient;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveConnectorId;
import com.facebook.presto.hive.HiveOutputTableHandle;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HiveRecordCursorProviders;
import com.facebook.presto.hive.HiveRecordSet;
import com.facebook.presto.hive.HiveRecordSink;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveSplitSourceProvider;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.PartitionOfflineException;
import com.facebook.presto.hive.PrestoS3FileSystem;
import com.facebook.presto.hive.TableOfflineException;
import com.facebook.presto.hive.UnpartitionedPartition;
import com.facebook.presto.hive.util.BoundedExecutor;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorOutputHandleResolver;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Domain;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.OutputTableHandle;
import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.PartitionResult;
import com.facebook.presto.spi.Range;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.RecordSink;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.Split;
import com.facebook.presto.spi.SplitSource;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.ProtectMode;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.mapred.JobConf;

public class HiveClient
implements ConnectorMetadata,
ConnectorSplitManager,
ConnectorRecordSetProvider,
ConnectorRecordSinkProvider,
ConnectorHandleResolver,
ConnectorOutputHandleResolver {
    private static final Logger log;
    private final String connectorId;
    private final int maxOutstandingSplits;
    private final int maxSplitIteratorThreads;
    private final int minPartitionBatchSize;
    private final int maxPartitionBatchSize;
    private final CachingHiveMetastore metastore;
    private final NamenodeStats namenodeStats;
    private final HdfsEnvironment hdfsEnvironment;
    private final DirectoryLister directoryLister;
    private final Executor executor;
    private final DataSize maxSplitSize;

    @Inject
    public HiveClient(HiveConnectorId connectorId, HiveClientConfig hiveClientConfig, CachingHiveMetastore metastore, NamenodeStats namenodeStats, HdfsEnvironment hdfsEnvironment, DirectoryLister directoryLister, @ForHiveClient ExecutorService executorService) {
        this(connectorId, metastore, namenodeStats, hdfsEnvironment, directoryLister, new BoundedExecutor(executorService, hiveClientConfig.getMaxGlobalSplitIteratorThreads()), hiveClientConfig.getMaxSplitSize(), hiveClientConfig.getMaxOutstandingSplits(), hiveClientConfig.getMaxSplitIteratorThreads(), hiveClientConfig.getMinPartitionBatchSize(), hiveClientConfig.getMaxPartitionBatchSize());
    }

    public HiveClient(HiveConnectorId connectorId, CachingHiveMetastore metastore, NamenodeStats namenodeStats, HdfsEnvironment hdfsEnvironment, DirectoryLister directoryLister, Executor executor, DataSize maxSplitSize, int maxOutstandingSplits, int maxSplitIteratorThreads, int minPartitionBatchSize, int maxPartitionBatchSize) {
        this.connectorId = ((HiveConnectorId)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null")).toString();
        this.maxSplitSize = (DataSize)Preconditions.checkNotNull((Object)maxSplitSize, (Object)"maxSplitSize is null");
        Preconditions.checkArgument((maxOutstandingSplits > 0 ? 1 : 0) != 0, (Object)"maxOutstandingSplits must be at least 1");
        this.maxOutstandingSplits = maxOutstandingSplits;
        this.maxSplitIteratorThreads = maxSplitIteratorThreads;
        this.minPartitionBatchSize = minPartitionBatchSize;
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        this.metastore = (CachingHiveMetastore)Preconditions.checkNotNull((Object)metastore, (Object)"metastore is null");
        this.hdfsEnvironment = (HdfsEnvironment)Preconditions.checkNotNull((Object)hdfsEnvironment, (Object)"hdfsEnvironment is null");
        this.namenodeStats = (NamenodeStats)Preconditions.checkNotNull((Object)namenodeStats, (Object)"namenodeStats is null");
        this.directoryLister = (DirectoryLister)Preconditions.checkNotNull((Object)directoryLister, (Object)"directoryLister is null");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
    }

    public CachingHiveMetastore getMetastore() {
        return this.metastore;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public List<String> listSchemaNames() {
        return this.metastore.getAllDatabases();
    }

    public HiveTableHandle getTableHandle(SchemaTableName tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        try {
            this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
            return new HiveTableHandle(this.connectorId, tableName.getSchemaName(), tableName.getTableName());
        }
        catch (NoSuchObjectException e) {
            return null;
        }
    }

    private static SchemaTableName getTableName(TableHandle tableHandle) {
        Preconditions.checkArgument((boolean)(tableHandle instanceof HiveTableHandle), (Object)"tableHandle is not an instance of HiveTableHandle");
        return ((HiveTableHandle)tableHandle).getSchemaTableName();
    }

    public ConnectorTableMetadata getTableMetadata(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        SchemaTableName tableName = HiveClient.getTableName(tableHandle);
        return this.getTableMetadata(tableName);
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        try {
            Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
            ImmutableList columns = ImmutableList.copyOf((Iterable)Iterables.transform(this.getColumnHandles(table, false), HiveColumnHandle.columnMetadataGetter()));
            return new ConnectorTableMetadata(tableName, (List)columns, table.getOwner());
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(tableName);
        }
    }

    public List<SchemaTableName> listTables(String schemaNameOrNull) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(schemaNameOrNull)) {
            try {
                for (String tableName : this.metastore.getAllTables(schemaName)) {
                    tableNames.add((Object)new SchemaTableName(schemaName, tableName));
                }
            }
            catch (NoSuchObjectException e) {
            }
        }
        return tableNames.build();
    }

    private List<String> listSchemas(String schemaNameOrNull) {
        if (schemaNameOrNull == null) {
            return this.listSchemaNames();
        }
        return ImmutableList.of((Object)schemaNameOrNull);
    }

    public ColumnHandle getColumnHandle(TableHandle tableHandle, String columnName) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkNotNull((Object)columnName, (Object)"columnName is null");
        return this.getColumnHandles(tableHandle).get(columnName);
    }

    public ColumnHandle getSampleWeightColumnHandle(TableHandle tableHandle) {
        SchemaTableName tableName = HiveClient.getTableName(tableHandle);
        try {
            Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
            for (HiveColumnHandle columnHandle : this.getColumnHandles(table, true)) {
                if (!columnHandle.getName().equals("__presto__sample_weight__")) continue;
                return columnHandle;
            }
            return null;
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(tableName);
        }
    }

    public boolean canCreateSampledTables() {
        return true;
    }

    public Map<String, ColumnHandle> getColumnHandles(TableHandle tableHandle) {
        SchemaTableName tableName = HiveClient.getTableName(tableHandle);
        try {
            Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
            ImmutableMap.Builder columnHandles = ImmutableMap.builder();
            for (HiveColumnHandle columnHandle : this.getColumnHandles(table, false)) {
                columnHandles.put((Object)columnHandle.getName(), (Object)columnHandle);
            }
            return columnHandles.build();
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(tableName);
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<HiveColumnHandle> getColumnHandles(Table table, boolean includeSampleWeight) {
        try {
            void var6_9;
            ImmutableList.Builder columns = ImmutableList.builder();
            int hiveColumnIndex = 0;
            for (StructField structField : HiveUtil.getTableStructFields(table)) {
                HiveType hiveType = HiveType.getHiveType(structField.getFieldObjectInspector());
                if (hiveType != null && (includeSampleWeight || !structField.getFieldName().equals("__presto__sample_weight__"))) {
                    columns.add((Object)new HiveColumnHandle(this.connectorId, structField.getFieldName(), hiveColumnIndex, hiveType, hiveColumnIndex, false));
                }
                ++hiveColumnIndex;
            }
            List partitionKeys = table.getPartitionKeys();
            boolean bl = false;
            while (var6_9 < partitionKeys.size()) {
                FieldSchema field = (FieldSchema)partitionKeys.get((int)var6_9);
                HiveType hiveType = HiveType.getSupportedHiveType(field.getType());
                columns.add((Object)new HiveColumnHandle(this.connectorId, field.getName(), hiveColumnIndex + var6_9, hiveType, -1, true));
                ++var6_9;
            }
            return columns.build();
        }
        catch (MetaException | SerDeException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(SchemaTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(prefix)) {
            try {
                columns.put((Object)tableName, (Object)this.getTableMetadata(tableName).getColumns());
            }
            catch (TableNotFoundException e) {}
        }
        return columns.build();
    }

    private List<SchemaTableName> listTables(SchemaTablePrefix prefix) {
        if (prefix.getSchemaName() == null) {
            return this.listTables(prefix.getSchemaName());
        }
        return ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
    }

    public ColumnMetadata getColumnMetadata(TableHandle tableHandle, ColumnHandle columnHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof HiveTableHandle), (Object)"tableHandle is not an instance of HiveTableHandle");
        Preconditions.checkArgument((boolean)(columnHandle instanceof HiveColumnHandle), (Object)"columnHandle is not an instance of HiveColumnHandle");
        return ((HiveColumnHandle)columnHandle).getColumnMetadata();
    }

    public TableHandle createTable(ConnectorTableMetadata tableMetadata) {
        throw new UnsupportedOperationException();
    }

    public void dropTable(TableHandle tableHandle) {
        throw new UnsupportedOperationException();
    }

    public HiveOutputTableHandle beginCreateTable(ConnectorTableMetadata tableMetadata) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableMetadata.getOwner()) ? 1 : 0) != 0, (Object)"Table owner is null or empty");
        ImmutableList.Builder columnNames = ImmutableList.builder();
        ImmutableList.Builder columnTypes = ImmutableList.builder();
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            columnNames.add((Object)column.getName());
            columnTypes.add((Object)column.getType());
        }
        if (tableMetadata.isSampled()) {
            columnNames.add((Object)"__presto__sample_weight__");
            columnTypes.add((Object)ColumnType.LONG);
        }
        SchemaTableName table = tableMetadata.getTable();
        String schemaName = table.getSchemaName();
        String tableName = table.getTableName();
        String location = this.getDatabase(schemaName).getLocationUri();
        if (Strings.isNullOrEmpty((String)location)) {
            throw new RuntimeException(String.format("Database '%s' location is not set", schemaName));
        }
        Path databasePath = new Path(location);
        if (!this.pathExists(databasePath)) {
            throw new RuntimeException(String.format("Database '%s' location does not exist: %s", schemaName, databasePath));
        }
        if (!this.isDirectory(databasePath)) {
            throw new RuntimeException(String.format("Database '%s' location is not a directory: %s", schemaName, databasePath));
        }
        Path targetPath = new Path(databasePath, tableName);
        if (this.pathExists(targetPath)) {
            throw new RuntimeException(String.format("Target directory for table '%s' already exists: %s", table, targetPath));
        }
        if (!this.useTemporaryDirectory(targetPath)) {
            return new HiveOutputTableHandle(this.connectorId, schemaName, tableName, (List<String>)columnNames.build(), (List<ColumnType>)columnTypes.build(), tableMetadata.getOwner(), targetPath.toString(), targetPath.toString());
        }
        String temporaryPrefix = "/tmp/presto-" + StandardSystemProperty.USER_NAME.value();
        Path temporaryRoot = new Path(targetPath, temporaryPrefix);
        Path temporaryPath = new Path(temporaryRoot, UUID.randomUUID().toString());
        this.createDirectories(temporaryPath);
        return new HiveOutputTableHandle(this.connectorId, schemaName, tableName, (List<String>)columnNames.build(), (List<ColumnType>)columnTypes.build(), tableMetadata.getOwner(), targetPath.toString(), temporaryPath.toString());
    }

    public void commitCreateTable(OutputTableHandle tableHandle, Collection<String> fragments) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof HiveOutputTableHandle), (Object)"tableHandle is not an instance of HiveOutputTableHandle");
        HiveOutputTableHandle handle = (HiveOutputTableHandle)tableHandle;
        Path targetPath = new Path(handle.getTargetPath());
        if (handle.hasTemporaryPath()) {
            if (this.pathExists(targetPath)) {
                SchemaTableName table = new SchemaTableName(handle.getSchemaName(), handle.getTableName());
                throw new RuntimeException(String.format("Unable to commit creation of table '%s': target directory already exists: %s", table, targetPath));
            }
            this.rename(new Path(handle.getTemporaryPath()), targetPath);
        }
        ImmutableList types = FluentIterable.from(handle.getColumnTypes()).transform(HiveType.columnTypeToHiveType()).transform(HiveType.hiveTypeNameGetter()).toList();
        boolean sampled = false;
        ImmutableList.Builder columns = ImmutableList.builder();
        for (int i = 0; i < handle.getColumnNames().size(); ++i) {
            String name = handle.getColumnNames().get(i);
            String type = (String)types.get(i);
            if (name.equals("__presto__sample_weight__")) {
                columns.add((Object)new FieldSchema(name, type, "Presto sample weight column"));
                sampled = true;
                continue;
            }
            columns.add((Object)new FieldSchema(name, type, null));
        }
        SerDeInfo serdeInfo = new SerDeInfo();
        serdeInfo.setName(handle.getTableName());
        serdeInfo.setSerializationLib(LazyBinaryColumnarSerDe.class.getName());
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation(targetPath.toString());
        sd.setCols((List)columns.build());
        sd.setSerdeInfo(serdeInfo);
        sd.setInputFormat(RCFileInputFormat.class.getName());
        sd.setOutputFormat(RCFileOutputFormat.class.getName());
        Table table = new Table();
        table.setDbName(handle.getSchemaName());
        table.setTableName(handle.getTableName());
        table.setOwner(handle.getTableOwner());
        table.setTableType(TableType.MANAGED_TABLE.toString());
        String tableComment = "Created by Presto";
        if (sampled) {
            tableComment = "Sampled table created by Presto. Only query this table from Hive if you understand how Presto implements sampling.";
        }
        table.setParameters((Map)ImmutableMap.of((Object)"comment", (Object)tableComment));
        table.setSd(sd);
        this.metastore.createTable(table);
    }

    public RecordSink getRecordSink(OutputTableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof HiveOutputTableHandle), (Object)"tableHandle is not an instance of HiveOutputTableHandle");
        HiveOutputTableHandle handle = (HiveOutputTableHandle)tableHandle;
        Path target = new Path(handle.getTemporaryPath(), UUID.randomUUID().toString());
        JobConf conf = new JobConf(this.hdfsEnvironment.getConfiguration(target));
        return new HiveRecordSink(handle, target, conf);
    }

    private Database getDatabase(String database) {
        try {
            return this.metastore.getDatabase(database);
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(database);
        }
    }

    private boolean useTemporaryDirectory(Path path) {
        try {
            return !(this.getFileSystem(path) instanceof PrestoS3FileSystem);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed checking path: " + path, e);
        }
    }

    private boolean pathExists(Path path) {
        try {
            return this.getFileSystem(path).exists(path);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed checking path: " + path, e);
        }
    }

    private boolean isDirectory(Path path) {
        try {
            return this.getFileSystem(path).isDirectory(path);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed checking path: " + path, e);
        }
    }

    private void createDirectories(Path path) {
        try {
            if (!this.getFileSystem(path).mkdirs(path)) {
                throw new IOException("mkdirs returned false");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create directory: " + path, e);
        }
    }

    private FileSystem getFileSystem(Path path) throws IOException {
        return path.getFileSystem(this.hdfsEnvironment.getConfiguration(path));
    }

    private void rename(Path source, Path target) {
        try {
            if (!this.getFileSystem(source).rename(source, target)) {
                throw new IOException("rename returned false");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to rename %s to %s", source, target), e);
        }
    }

    public PartitionResult getPartitions(TableHandle tableHandle, TupleDomain tupleDomain) {
        Object partitionNames;
        Optional<HiveBucketing.HiveBucket> bucket;
        List partitionKeys;
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkNotNull((Object)tupleDomain, (Object)"tupleDomain is null");
        SchemaTableName tableName = HiveClient.getTableName(tableHandle);
        try {
            Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
            String protectMode = (String)table.getParameters().get(ProtectMode.PARAMETER_NAME);
            if (protectMode != null && ProtectMode.getProtectModeFromString((String)protectMode).offline) {
                throw new TableOfflineException(tableName);
            }
            partitionKeys = table.getPartitionKeys();
            bucket = HiveBucketing.getHiveBucket(table, tupleDomain.extractFixedValues());
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(tableName);
        }
        ImmutableMap.Builder partitionKeysByNameBuilder = ImmutableMap.builder();
        ArrayList<String> filterPrefix = new ArrayList<String>();
        for (int i = 0; i < partitionKeys.size(); ++i) {
            Range range;
            Domain domain;
            FieldSchema field = (FieldSchema)partitionKeys.get(i);
            HiveColumnHandle columnHandle = new HiveColumnHandle(this.connectorId, field.getName(), i, HiveType.getSupportedHiveType(field.getType()), -1, true);
            partitionKeysByNameBuilder.put((Object)field.getName(), (Object)columnHandle);
            if (filterPrefix.size() != i || tupleDomain.isNone() || (domain = (Domain)tupleDomain.getDomains().get(columnHandle)) == null || domain.getRanges().getRangeCount() != 1 || !(range = (Range)Iterables.getOnlyElement((Iterable)domain.getRanges())).isSingleValue()) continue;
            Comparable value = range.getLow().getValue();
            Preconditions.checkArgument((value instanceof Boolean || value instanceof String || value instanceof Double || value instanceof Long ? 1 : 0) != 0, (Object)"Only Boolean, String, Double and Long partition keys are supported");
            filterPrefix.add(value.toString());
        }
        try {
            partitionNames = partitionKeys.isEmpty() ? ImmutableList.of((Object)"<UNPARTITIONED>") : (filterPrefix.isEmpty() ? this.metastore.getPartitionNames(tableName.getSchemaName(), tableName.getTableName()) : this.metastore.getPartitionNamesByParts(tableName.getSchemaName(), tableName.getTableName(), filterPrefix));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(tableName);
        }
        ImmutableMap partitionKeysByName = partitionKeysByNameBuilder.build();
        ImmutableList partitions = FluentIterable.from((Iterable)partitionNames).transform(HiveClient.toPartition(tableName, (Map<String, ColumnHandle>)partitionKeysByName, bucket)).filter(HiveClient.partitionMatches(tupleDomain)).filter(Partition.class).toList();
        TupleDomain remainingTupleDomain = TupleDomain.none();
        if (!tupleDomain.isNone()) {
            remainingTupleDomain = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)tupleDomain.getDomains(), (Predicate)Predicates.not((Predicate)Predicates.in(partitionKeysByName.values()))));
        }
        return new PartitionResult((List)partitions, remainingTupleDomain);
    }

    public SplitSource getPartitionSplits(TableHandle tableHandle, List<Partition> partitions) {
        Iterable<org.apache.hadoop.hive.metastore.api.Partition> hivePartitions;
        Table table;
        Preconditions.checkNotNull(partitions, (Object)"partitions is null");
        Partition partition = (Partition)Iterables.getFirst(partitions, null);
        if (partition == null) {
            return new FixedSplitSource(this.connectorId, (Iterable)ImmutableList.of());
        }
        Preconditions.checkArgument((boolean)(partition instanceof HivePartition), (Object)"Partition must be a hive partition");
        SchemaTableName tableName = ((HivePartition)partition).getTableName();
        Optional<HiveBucketing.HiveBucket> bucket = ((HivePartition)partition).getBucket();
        ArrayList<String> partitionNames = new ArrayList<String>(Lists.transform(partitions, HiveUtil.partitionIdGetter()));
        Collections.sort(partitionNames, Ordering.natural().reverse());
        try {
            table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
            hivePartitions = this.getPartitions(table, tableName, partitionNames);
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(tableName);
        }
        return new HiveSplitSourceProvider(this.connectorId, table, partitionNames, hivePartitions, bucket, this.maxSplitSize, this.maxOutstandingSplits, this.maxSplitIteratorThreads, this.hdfsEnvironment, this.namenodeStats, this.directoryLister, this.executor, this.maxPartitionBatchSize).get();
    }

    private Iterable<org.apache.hadoop.hive.metastore.api.Partition> getPartitions(final Table table, final SchemaTableName tableName, List<String> partitionNames) throws NoSuchObjectException {
        if (partitionNames.equals(ImmutableList.of((Object)"<UNPARTITIONED>"))) {
            return ImmutableList.of((Object)UnpartitionedPartition.UNPARTITIONED_PARTITION);
        }
        Iterable<List<String>> partitionNameBatches = HiveClient.partitionExponentially(partitionNames, this.minPartitionBatchSize, this.maxPartitionBatchSize);
        Iterable partitionBatches = Iterables.transform(partitionNameBatches, (Function)new Function<List<String>, List<org.apache.hadoop.hive.metastore.api.Partition>>(){

            public List<org.apache.hadoop.hive.metastore.api.Partition> apply(List<String> partitionNameBatch) {
                Throwable exception = null;
                for (int attempt = 0; attempt < 10; ++attempt) {
                    try {
                        List<org.apache.hadoop.hive.metastore.api.Partition> partitions = HiveClient.this.metastore.getPartitionsByNames(tableName.getSchemaName(), tableName.getTableName(), partitionNameBatch);
                        Preconditions.checkState((partitionNameBatch.size() == partitions.size() ? 1 : 0) != 0, (String)"expected %s partitions but found %s", (Object[])new Object[]{partitionNameBatch.size(), partitions.size()});
                        for (org.apache.hadoop.hive.metastore.api.Partition partition : partitions) {
                            String protectMode = (String)partition.getParameters().get(ProtectMode.PARAMETER_NAME);
                            if (protectMode == null || !ProtectMode.getProtectModeFromString((String)protectMode).offline) continue;
                            throw new PartitionOfflineException(tableName, Warehouse.makePartName((List)table.getPartitionKeys(), (List)partition.getValues()));
                        }
                        return partitions;
                    }
                    catch (IllegalArgumentException | IllegalStateException | NullPointerException | NoSuchObjectException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                    catch (RuntimeException | MetaException e) {
                        exception = e;
                        log.debug("getPartitions attempt %s failed, will retry. Exception: %s", new Object[]{attempt, e.getMessage()});
                        try {
                            TimeUnit.SECONDS.sleep(1L);
                            continue;
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                            throw Throwables.propagate((Throwable)e2);
                        }
                    }
                }
                throw Throwables.propagate(exception);
            }
        });
        return Iterables.concat((Iterable)partitionBatches);
    }

    public RecordSet getRecordSet(Split split, List<? extends ColumnHandle> columns) {
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        Preconditions.checkArgument((boolean)(split instanceof HiveSplit), (String)"expected instance of %s: %s", (Object[])new Object[]{HiveSplit.class, split.getClass()});
        ImmutableList hiveColumns = ImmutableList.copyOf((Iterable)Iterables.transform(columns, HiveColumnHandle.hiveColumnHandle()));
        return new HiveRecordSet(this.hdfsEnvironment, (HiveSplit)split, (List<HiveColumnHandle>)hiveColumns, HiveRecordCursorProviders.getDefaultProviders());
    }

    public boolean canHandle(TableHandle tableHandle) {
        return tableHandle instanceof HiveTableHandle && ((HiveTableHandle)tableHandle).getClientId().equals(this.connectorId);
    }

    public boolean canHandle(ColumnHandle columnHandle) {
        return columnHandle instanceof HiveColumnHandle && ((HiveColumnHandle)columnHandle).getClientId().equals(this.connectorId);
    }

    public boolean canHandle(Split split) {
        return split instanceof HiveSplit && ((HiveSplit)split).getClientId().equals(this.connectorId);
    }

    public boolean canHandle(OutputTableHandle handle) {
        return handle instanceof HiveOutputTableHandle && ((HiveOutputTableHandle)handle).getClientId().equals(this.connectorId);
    }

    public Class<? extends TableHandle> getTableHandleClass() {
        return HiveTableHandle.class;
    }

    public Class<? extends ColumnHandle> getColumnHandleClass() {
        return HiveColumnHandle.class;
    }

    public Class<? extends Split> getSplitClass() {
        return HiveSplit.class;
    }

    public Class<? extends OutputTableHandle> getOutputTableHandleClass() {
        return HiveOutputTableHandle.class;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("clientId", (Object)this.connectorId).toString();
    }

    private static Function<String, HivePartition> toPartition(final SchemaTableName tableName, final Map<String, ColumnHandle> columnsByName, final Optional<HiveBucketing.HiveBucket> bucket) {
        return new Function<String, HivePartition>(){

            public HivePartition apply(String partitionId) {
                try {
                    if (partitionId.equals("<UNPARTITIONED>")) {
                        return new HivePartition(tableName);
                    }
                    LinkedHashMap keys = Warehouse.makeSpecFromName((String)partitionId);
                    ImmutableMap.Builder builder = ImmutableMap.builder();
                    for (Map.Entry entry : keys.entrySet()) {
                        ColumnHandle columnHandle = (ColumnHandle)columnsByName.get(entry.getKey());
                        Preconditions.checkArgument((columnHandle != null ? 1 : 0) != 0, (String)"Invalid partition key %s in partition %s", (Object[])new Object[]{entry.getKey(), partitionId});
                        Preconditions.checkArgument((boolean)(columnHandle instanceof HiveColumnHandle), (Object)"columnHandle is not an instance of HiveColumnHandle");
                        HiveColumnHandle hiveColumnHandle = (HiveColumnHandle)columnHandle;
                        String value = (String)entry.getValue();
                        switch (hiveColumnHandle.getType()) {
                            case BOOLEAN: {
                                if (value.isEmpty()) {
                                    builder.put((Object)columnHandle, (Object)false);
                                    break;
                                }
                                builder.put((Object)columnHandle, (Object)Boolean.parseBoolean(value));
                                break;
                            }
                            case LONG: {
                                if (value.isEmpty()) {
                                    builder.put((Object)columnHandle, (Object)0L);
                                    break;
                                }
                                if (hiveColumnHandle.getHiveType() == HiveType.TIMESTAMP) {
                                    builder.put((Object)columnHandle, (Object)HiveUtil.parseHiveTimestamp(value));
                                    break;
                                }
                                builder.put((Object)columnHandle, (Object)Long.parseLong(value));
                                break;
                            }
                            case DOUBLE: {
                                if (value.isEmpty()) {
                                    builder.put((Object)columnHandle, (Object)0.0);
                                    break;
                                }
                                builder.put((Object)columnHandle, (Object)Double.parseDouble(value));
                                break;
                            }
                            case STRING: {
                                builder.put((Object)columnHandle, (Object)value);
                            }
                        }
                    }
                    return new HivePartition(tableName, partitionId, (Map<ColumnHandle, Comparable<?>>)builder.build(), (Optional<HiveBucketing.HiveBucket>)bucket);
                }
                catch (MetaException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
    }

    public static Predicate<HivePartition> partitionMatches(final TupleDomain tupleDomain) {
        return new Predicate<HivePartition>(){

            public boolean apply(HivePartition partition) {
                if (tupleDomain.isNone()) {
                    return false;
                }
                for (Map.Entry<ColumnHandle, Comparable<?>> entry : partition.getKeys().entrySet()) {
                    Domain allowedDomain = (Domain)tupleDomain.getDomains().get(entry.getKey());
                    if (allowedDomain == null || allowedDomain.includesValue(entry.getValue())) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private static <T> Iterable<List<T>> partitionExponentially(final List<T> values, final int minBatchSize, final int maxBatchSize) {
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return new AbstractIterator<List<T>>(){
                    private int currentSize;
                    private final Iterator<T> iterator;
                    {
                        this.currentSize = minBatchSize;
                        this.iterator = values.iterator();
                    }

                    protected List<T> computeNext() {
                        if (!this.iterator.hasNext()) {
                            return (List)this.endOfData();
                        }
                        ImmutableList.Builder builder = ImmutableList.builder();
                        for (int count = 0; this.iterator.hasNext() && count < this.currentSize; ++count) {
                            builder.add(this.iterator.next());
                        }
                        this.currentSize = Math.min(maxBatchSize, this.currentSize * 2);
                        return builder.build();
                    }
                };
            }
        };
    }

    static {
        HadoopNative.requireHadoopNative();
        HadoopFileSystemCache.initialize();
        log = Logger.get(HiveClient.class);
    }
}

