/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.CachingHiveMetastore;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.DiscoveryLocatedHiveCluster;
import com.facebook.presto.hive.ForHiveClient;
import com.facebook.presto.hive.ForHiveMetastore;
import com.facebook.presto.hive.HadoopDirectoryLister;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClient;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveCluster;
import com.facebook.presto.hive.HiveConnectorId;
import com.facebook.presto.hive.HiveMetastoreClientFactory;
import com.facebook.presto.hive.HivePluginConfig;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.StaticHiveCluster;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.discovery.client.DiscoveryBinder;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Singleton;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.guice.ExportBinder;

public class HiveClientModule
implements Module {
    private final String connectorId;

    public HiveClientModule(String connectorId) {
        this.connectorId = connectorId;
    }

    public void configure(Binder binder) {
        binder.bind(HiveConnectorId.class).toInstance((Object)new HiveConnectorId(this.connectorId));
        binder.bind(HiveClient.class).in(Scopes.SINGLETON);
        binder.bind(HdfsConfiguration.class).in(Scopes.SINGLETON);
        binder.bind(HdfsEnvironment.class).in(Scopes.SINGLETON);
        binder.bind(DirectoryLister.class).to(HadoopDirectoryLister.class).in(Scopes.SINGLETON);
        ConfigurationModule.bindConfig((Binder)binder).to(HiveClientConfig.class);
        ConfigurationModule.bindConfig((Binder)binder).to(HivePluginConfig.class);
        binder.bind(CachingHiveMetastore.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(CachingHiveMetastore.class).as(ObjectNames.generatedNameOf(CachingHiveMetastore.class, (String)this.connectorId));
        binder.bind(NamenodeStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(NamenodeStats.class).as(ObjectNames.generatedNameOf(NamenodeStats.class));
        binder.bind(DiscoveryLocatedHiveCluster.class).in(Scopes.SINGLETON);
        binder.bind(HiveMetastoreClientFactory.class).in(Scopes.SINGLETON);
        DiscoveryBinder.discoveryBinder((Binder)binder).bindSelector("hive-metastore");
    }

    @ForHiveClient
    @Singleton
    @Provides
    public ExecutorService createHiveClientExecutor(HiveConnectorId hiveClientId) {
        return Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("hive-" + hiveClientId + "-%d").build());
    }

    @ForHiveMetastore
    @Singleton
    @Provides
    public ExecutorService createCachingHiveMetastoreExecutor(HiveConnectorId hiveClientId, HiveClientConfig hiveClientConfig) {
        return Executors.newFixedThreadPool(hiveClientConfig.getMaxMetastoreRefreshThreads(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("hive-metastore-" + hiveClientId + "-%d").build());
    }

    @Singleton
    @Provides
    public HiveCluster createHiveCluster(Injector injector, HivePluginConfig config) {
        URI uri = (URI)Preconditions.checkNotNull((Object)config.getMetastoreUri(), (Object)"metastoreUri is null");
        String scheme = uri.getScheme();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)scheme) ? 1 : 0) != 0, (String)"metastoreUri scheme is missing: %s", (Object[])new Object[]{uri});
        switch (scheme) {
            case "discovery": {
                return (HiveCluster)injector.getInstance(DiscoveryLocatedHiveCluster.class);
            }
            case "thrift": {
                Preconditions.checkArgument((uri.getHost() != null ? 1 : 0) != 0, (String)"metastoreUri host is missing: %s", (Object[])new Object[]{uri});
                Preconditions.checkArgument((uri.getPort() != -1 ? 1 : 0) != 0, (String)"metastoreUri port is missing: %s", (Object[])new Object[]{uri});
                HostAndPort address = HostAndPort.fromParts((String)uri.getHost(), (int)uri.getPort());
                return new StaticHiveCluster(address, (HiveMetastoreClientFactory)injector.getInstance(HiveMetastoreClientFactory.class));
            }
        }
        throw new IllegalArgumentException("unsupported metastoreUri: " + uri);
    }
}

