/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.shaded.org.apache.thrift.TException;
import io.airlift.stats.CounterStat;
import io.airlift.stats.TimeStat;
import java.util.concurrent.Callable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class HiveMetastoreApiStats {
    private final TimeStat time = new TimeStat();
    private final CounterStat totalFailures = new CounterStat();
    private final CounterStat metastoreExceptions = new CounterStat();
    private final CounterStat thriftExceptions = new CounterStat();

    public <V> Callable<V> wrap(final Callable<V> callable) {
        return new Callable<V>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public V call() throws Exception {
                try (TimeStat.BlockTimer timer = HiveMetastoreApiStats.this.time.time();){
                    Object v = callable.call();
                    return v;
                }
                catch (Exception e) {
                    if (e instanceof MetaException) {
                        HiveMetastoreApiStats.this.metastoreExceptions.update(1L);
                    } else if (e instanceof TException) {
                        HiveMetastoreApiStats.this.thriftExceptions.update(1L);
                    }
                    HiveMetastoreApiStats.this.totalFailures.update(1L);
                    throw e;
                }
            }
        };
    }

    @Managed
    @Nested
    public TimeStat getTime() {
        return this.time;
    }

    @Managed
    @Nested
    public CounterStat getTotalFailures() {
        return this.totalFailures;
    }

    @Managed
    @Nested
    public CounterStat getThriftExceptions() {
        return this.thriftExceptions;
    }

    @Managed
    @Nested
    public CounterStat getMetastoreExceptions() {
        return this.metastoreExceptions;
    }
}

