/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveMetastoreClient;
import com.facebook.presto.hive.shaded.org.apache.thrift.transport.TSocket;
import com.facebook.presto.hive.shaded.org.apache.thrift.transport.TTransport;
import com.facebook.presto.hive.shaded.org.apache.thrift.transport.TTransportException;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import javax.annotation.Nullable;

public class HiveMetastoreClientFactory {
    private final HostAndPort socksProxy;
    private final Duration timeout;

    public HiveMetastoreClientFactory(@Nullable HostAndPort socksProxy, Duration timeout) {
        this.socksProxy = socksProxy;
        this.timeout = (Duration)Preconditions.checkNotNull((Object)timeout, (Object)"timeout is null");
    }

    @Inject
    public HiveMetastoreClientFactory(HiveClientConfig config) {
        this(config.getMetastoreSocksProxy(), config.getMetastoreTimeout());
    }

    public HiveMetastoreClient create(String host, int port) throws TTransportException {
        TSocket transport;
        if (this.socksProxy == null) {
            transport = new TSocket(host, port, (int)this.timeout.toMillis());
            transport.open();
        } else {
            InetSocketAddress address = InetSocketAddress.createUnresolved(this.socksProxy.getHostText(), this.socksProxy.getPort());
            Socket socks = new Socket(new Proxy(Proxy.Type.SOCKS, address));
            try {
                socks.connect(InetSocketAddress.createUnresolved(host, port), (int)this.timeout.toMillis());
                socks.setSoTimeout(Ints.checkedCast((long)this.timeout.toMillis()));
            }
            catch (IOException e) {
                throw new TTransportException((Throwable)e);
            }
            transport = new TSocket(socks);
        }
        return new HiveMetastoreClient((TTransport)transport);
    }
}

