/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class HiveTableHandle
implements TableHandle {
    private final String clientId;
    private final String schemaName;
    private final String tableName;

    @JsonCreator
    public HiveTableHandle(@JsonProperty(value="clientId") String clientId, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName) {
        this.clientId = (String)Preconditions.checkNotNull((Object)clientId, (Object)"clientId is null");
        this.schemaName = (String)Preconditions.checkNotNull((Object)schemaName, (Object)"schemaName is null");
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
    }

    @JsonProperty
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.clientId, this.schemaName, this.tableName});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HiveTableHandle other = (HiveTableHandle)obj;
        return Objects.equal((Object)this.clientId, (Object)other.clientId) && Objects.equal((Object)this.schemaName, (Object)other.schemaName) && Objects.equal((Object)this.tableName, (Object)other.tableName);
    }

    public String toString() {
        return this.clientId + ":" + this.schemaName + ":" + this.tableName;
    }
}

