/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.spi.Partition;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

final class HiveUtil {
    private static final DateTimeFormatter HIVE_TIMESTAMP_PARSER = new DateTimeFormatterBuilder().append(DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss")).appendOptional(DateTimeFormat.forPattern((String)".SSSSSSSSS").getParser()).toFormatter();

    private HiveUtil() {
    }

    static InputFormat<?, ?> getInputFormat(Configuration configuration, Properties schema, boolean symlinkTarget) {
        String inputFormatName = HiveUtil.getInputFormatName(schema);
        try {
            JobConf jobConf = new JobConf(configuration);
            Class<? extends InputFormat<?, ?>> inputFormatClass = HiveUtil.getInputFormatClass(jobConf, inputFormatName);
            if (symlinkTarget && inputFormatClass == SymlinkTextInputFormat.class) {
                inputFormatClass = TextInputFormat.class;
            }
            return (InputFormat)ReflectionUtils.newInstance(inputFormatClass, (Configuration)jobConf);
        }
        catch (ClassNotFoundException | RuntimeException e) {
            throw new RuntimeException("Unable to create input format " + inputFormatName, e);
        }
    }

    private static Class<? extends InputFormat<?, ?>> getInputFormatClass(JobConf conf, String inputFormatName) throws ClassNotFoundException {
        Class clazz = conf.getClassByName(inputFormatName);
        return clazz.asSubclass(InputFormat.class);
    }

    static String getInputFormatName(Properties schema) {
        String name = schema.getProperty("file.inputformat");
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (String)"missing property: %s", (Object[])new Object[]{"file.inputformat"});
        return name;
    }

    static PrimitiveObjectInspector.PrimitiveCategory convertNativeHiveType(String type) {
        return PrimitiveObjectInspectorUtils.getTypeEntryFromTypeName((String)type).primitiveCategory;
    }

    public static Function<Partition, String> partitionIdGetter() {
        return new Function<Partition, String>(){

            public String apply(Partition input) {
                return input.getPartitionId();
            }
        };
    }

    public static long parseHiveTimestamp(String value) {
        return TimeUnit.MILLISECONDS.toSeconds(HIVE_TIMESTAMP_PARSER.parseMillis(value));
    }

    static boolean isSplittable(InputFormat<?, ?> inputFormat, FileSystem fileSystem, Path path) {
        Method method = null;
        for (Class<?> clazz = inputFormat.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                method = clazz.getDeclaredMethod("isSplitable", FileSystem.class, Path.class);
                break;
            }
            catch (NoSuchMethodException ignored) {
                continue;
            }
        }
        if (method == null) {
            return false;
        }
        try {
            method.setAccessible(true);
            return (Boolean)method.invoke(inputFormat, fileSystem, path);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static StructObjectInspector getTableObjectInspector(Properties schema) throws MetaException, SerDeException {
        ObjectInspector inspector = MetaStoreUtils.getDeserializer(null, (Properties)schema).getObjectInspector();
        Preconditions.checkArgument((inspector.getCategory() == ObjectInspector.Category.STRUCT ? 1 : 0) != 0, (String)"expected STRUCT: %s", (Object[])new Object[]{inspector.getCategory()});
        return (StructObjectInspector)inspector;
    }

    public static List<? extends StructField> getTableStructFields(Table table) throws MetaException, SerDeException {
        return HiveUtil.getTableObjectInspector(MetaStoreUtils.getTableMetadata((Table)table)).getAllStructFieldRefs();
    }
}

