/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.base.Preconditions;

public class TableOfflineException
extends PrestoException {
    private final SchemaTableName tableName;

    public TableOfflineException(SchemaTableName tableName) {
        this(tableName, String.format("Table '%s' is offline", tableName));
    }

    public TableOfflineException(SchemaTableName tableName, String message) {
        super(HiveErrorCode.HIVE_TABLE_OFFLINE.toErrorCode(), message);
        this.tableName = (SchemaTableName)Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }
}

