/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.shaded.org.apache.commons.configuration;

import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.AbstractConfiguration;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.Configuration;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.ConfigurationUtils;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.HierarchicalConfiguration;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.event.ConfigurationEvent;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.event.ConfigurationListener;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.tree.ConfigurationNode;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.tree.DefaultConfigurationKey;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.tree.DefaultConfigurationNode;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.tree.DefaultExpressionEngine;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.tree.ExpressionEngine;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.tree.NodeCombiner;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.tree.UnionCombiner;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.tree.ViewNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CombinedConfiguration
extends HierarchicalConfiguration
implements ConfigurationListener,
Cloneable {
    public static final int EVENT_COMBINED_INVALIDATE = 40;
    private static final long serialVersionUID = 8338574525528692307L;
    private static final DefaultExpressionEngine AT_ENGINE = new DefaultExpressionEngine();
    private static final NodeCombiner DEFAULT_COMBINER = new UnionCombiner();
    private static final String PROP_RELOAD_CHECK = "CombinedConfigurationReloadCheck";
    private NodeCombiner nodeCombiner;
    private volatile ConfigurationNode combinedRoot;
    private List configurations;
    private Map namedConfigurations;
    private ExpressionEngine conversionExpressionEngine;
    private boolean forceReloadCheck;

    public CombinedConfiguration(NodeCombiner comb) {
        this.setNodeCombiner(comb != null ? comb : DEFAULT_COMBINER);
        this.clear();
    }

    public CombinedConfiguration() {
        this((NodeCombiner)null);
    }

    public NodeCombiner getNodeCombiner() {
        return this.nodeCombiner;
    }

    public void setNodeCombiner(NodeCombiner nodeCombiner) {
        if (nodeCombiner == null) {
            throw new IllegalArgumentException("Node combiner must not be null!");
        }
        this.nodeCombiner = nodeCombiner;
        this.invalidate();
    }

    public boolean isForceReloadCheck() {
        return this.forceReloadCheck;
    }

    public void setForceReloadCheck(boolean forceReloadCheck) {
        this.forceReloadCheck = forceReloadCheck;
    }

    public ExpressionEngine getConversionExpressionEngine() {
        return this.conversionExpressionEngine;
    }

    public void setConversionExpressionEngine(ExpressionEngine conversionExpressionEngine) {
        this.conversionExpressionEngine = conversionExpressionEngine;
    }

    public void addConfiguration(AbstractConfiguration config, String name, String at) {
        if (config == null) {
            throw new IllegalArgumentException("Added configuration must not be null!");
        }
        if (name != null && this.namedConfigurations.containsKey(name)) {
            throw new ConfigurationRuntimeException("A configuration with the name '" + name + "' already exists in this combined configuration!");
        }
        ConfigData cd = new ConfigData(config, name, at);
        this.configurations.add(cd);
        if (name != null) {
            this.namedConfigurations.put(name, config);
        }
        config.addConfigurationListener(this);
        this.invalidate();
    }

    public void addConfiguration(AbstractConfiguration config, String name) {
        this.addConfiguration(config, name, null);
    }

    public void addConfiguration(AbstractConfiguration config) {
        this.addConfiguration(config, null, null);
    }

    public int getNumberOfConfigurations() {
        return this.configurations.size();
    }

    public Configuration getConfiguration(int index) {
        ConfigData cd = (ConfigData)this.configurations.get(index);
        return cd.getConfiguration();
    }

    public Configuration getConfiguration(String name) {
        return (Configuration)this.namedConfigurations.get(name);
    }

    public boolean removeConfiguration(Configuration config) {
        for (int index = 0; index < this.getNumberOfConfigurations(); ++index) {
            if (((ConfigData)this.configurations.get(index)).getConfiguration() != config) continue;
            this.removeConfigurationAt(index);
            return true;
        }
        return false;
    }

    public Configuration removeConfigurationAt(int index) {
        ConfigData cd = (ConfigData)this.configurations.remove(index);
        if (cd.getName() != null) {
            this.namedConfigurations.remove(cd.getName());
        }
        cd.getConfiguration().removeConfigurationListener(this);
        this.invalidate();
        return cd.getConfiguration();
    }

    public Configuration removeConfiguration(String name) {
        Configuration conf = this.getConfiguration(name);
        if (conf != null) {
            this.removeConfiguration(conf);
        }
        return conf;
    }

    public Set getConfigurationNames() {
        return this.namedConfigurations.keySet();
    }

    public void invalidate() {
        this.combinedRoot = null;
        this.fireEvent(40, null, null, false);
    }

    public void configurationChanged(ConfigurationEvent event) {
        if (!event.isBeforeUpdate()) {
            this.invalidate();
        }
    }

    public ConfigurationNode getRootNode() {
        if (this.combinedRoot == null) {
            this.combinedRoot = this.constructCombinedNode();
        }
        return this.combinedRoot;
    }

    public void clear() {
        this.fireEvent(4, null, null, true);
        this.configurations = new ArrayList();
        this.namedConfigurations = new HashMap();
        this.fireEvent(4, null, null, false);
        this.invalidate();
    }

    public Object clone() {
        CombinedConfiguration copy = (CombinedConfiguration)super.clone();
        copy.clear();
        Iterator it = this.configurations.iterator();
        while (it.hasNext()) {
            ConfigData cd = (ConfigData)it.next();
            copy.addConfiguration((AbstractConfiguration)ConfigurationUtils.cloneConfiguration(cd.getConfiguration()), cd.getName(), cd.getAt());
        }
        copy.setRootNode(new DefaultConfigurationNode());
        return copy;
    }

    public Configuration getSource(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null!");
        }
        List nodes = this.fetchNodeList(key);
        if (nodes.isEmpty()) {
            return null;
        }
        Iterator it = nodes.iterator();
        Configuration source = this.findSourceConfiguration((ConfigurationNode)it.next());
        while (it.hasNext()) {
            Configuration src = this.findSourceConfiguration((ConfigurationNode)it.next());
            if (src == source) continue;
            throw new IllegalArgumentException("The key " + key + " is defined by multiple sources!");
        }
        return source;
    }

    protected List fetchNodeList(String key) {
        if (this.isForceReloadCheck()) {
            this.performReloadCheck();
        }
        return super.fetchNodeList(key);
    }

    protected void performReloadCheck() {
        Iterator it = this.configurations.iterator();
        while (it.hasNext()) {
            try {
                ((ConfigData)it.next()).getConfiguration().getProperty(PROP_RELOAD_CHECK);
            }
            catch (Exception exception) {}
        }
    }

    private ConfigurationNode constructCombinedNode() {
        if (this.getNumberOfConfigurations() < 1) {
            return new ViewNode();
        }
        Iterator it = this.configurations.iterator();
        ConfigurationNode node = ((ConfigData)it.next()).getTransformedRoot();
        while (it.hasNext()) {
            node = this.getNodeCombiner().combine(node, ((ConfigData)it.next()).getTransformedRoot());
        }
        return node;
    }

    private Configuration findSourceConfiguration(ConfigurationNode node) {
        ConfigurationNode root = null;
        for (ConfigurationNode current = node; current != null; current = current.getParentNode()) {
            root = current;
        }
        Iterator it = this.configurations.iterator();
        while (it.hasNext()) {
            ConfigData cd = (ConfigData)it.next();
            if (root != cd.getRootNode()) continue;
            return cd.getConfiguration();
        }
        return this;
    }

    class ConfigData {
        private AbstractConfiguration configuration;
        private String name;
        private Collection atPath;
        private String at;
        private ConfigurationNode rootNode;

        public ConfigData(AbstractConfiguration config, String n, String at) {
            this.configuration = config;
            this.name = n;
            this.atPath = this.parseAt(at);
            this.at = at;
        }

        public AbstractConfiguration getConfiguration() {
            return this.configuration;
        }

        public String getName() {
            return this.name;
        }

        public String getAt() {
            return this.at;
        }

        public ConfigurationNode getRootNode() {
            return this.rootNode;
        }

        public ConfigurationNode getTransformedRoot() {
            ViewNode result;
            ViewNode atParent = result = new ViewNode();
            if (this.atPath != null) {
                Iterator it = this.atPath.iterator();
                while (it.hasNext()) {
                    ViewNode node = new ViewNode();
                    node.setName((String)it.next());
                    atParent.addChild(node);
                    atParent = node;
                }
            }
            HierarchicalConfiguration hc = ConfigurationUtils.convertToHierarchical(this.getConfiguration(), CombinedConfiguration.this.getConversionExpressionEngine());
            atParent.appendChildren(hc.getRootNode());
            atParent.appendAttributes(hc.getRootNode());
            this.rootNode = hc.getRootNode();
            return result;
        }

        private Collection parseAt(String at) {
            if (at == null) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>();
            DefaultConfigurationKey.KeyIterator it = new DefaultConfigurationKey(AT_ENGINE, at).iterator();
            while (it.hasNext()) {
                result.add(it.nextKey());
            }
            return result;
        }
    }
}

