/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.server.tasktracker.userlogs;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.DefaultTaskController;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskLogsTruncater;
import org.apache.hadoop.mapred.UserLogCleaner;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.DeleteJobEvent;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.JobCompletedEvent;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.JobStartedEvent;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.JvmFinishedEvent;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.UserLogEvent;
import org.apache.hadoop.util.ReflectionUtils;

public class UserLogManager {
    private static final Log LOG = LogFactory.getLog(UserLogManager.class);
    private BlockingQueue<UserLogEvent> userLogEvents = new LinkedBlockingQueue<UserLogEvent>();
    private TaskLogsTruncater taskLogsTruncater;
    private UserLogCleaner userLogCleaner;
    private final TaskController taskController;
    private Thread monitorLogEvents = new Thread(){

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        UserLogManager.this.monitor();
                    }
                }
                catch (Exception e) {
                    LOG.warn("Exception while monitoring user log events", e);
                    continue;
                }
                break;
            }
        }
    };

    public UserLogManager(Configuration conf, TaskController taskController) throws IOException {
        this.taskController = taskController;
        this.setFields(conf);
    }

    public UserLogManager(Configuration conf) throws IOException {
        TaskController taskController;
        Class<TaskController> taskControllerClass = conf.getClass("mapred.task.tracker.task-controller", DefaultTaskController.class, TaskController.class);
        this.taskController = taskController = ReflectionUtils.newInstance(taskControllerClass, conf);
        this.setFields(conf);
    }

    private void setFields(Configuration conf) throws IOException {
        this.taskLogsTruncater = new TaskLogsTruncater(conf);
        this.userLogCleaner = new UserLogCleaner(this, conf);
        this.monitorLogEvents.setDaemon(true);
    }

    public TaskController getTaskController() {
        return this.taskController;
    }

    public void start() {
        this.userLogCleaner.start();
        this.monitorLogEvents.start();
    }

    protected void monitor() throws Exception {
        UserLogEvent event = this.userLogEvents.take();
        this.processEvent(event);
    }

    protected void processEvent(UserLogEvent event) throws IOException {
        if (event instanceof JvmFinishedEvent) {
            this.doJvmFinishedAction((JvmFinishedEvent)event);
        } else if (event instanceof JobCompletedEvent) {
            this.doJobCompletedAction((JobCompletedEvent)event);
        } else if (event instanceof JobStartedEvent) {
            this.doJobStartedAction((JobStartedEvent)event);
        } else if (event instanceof DeleteJobEvent) {
            this.doDeleteJobAction((DeleteJobEvent)event);
        } else {
            LOG.warn("Unknown event " + (Object)((Object)event.getEventType()) + " passed.");
        }
    }

    public void clearOldUserLogs(Configuration conf) throws IOException {
        this.userLogCleaner.clearOldUserLogs(conf);
    }

    private void doJvmFinishedAction(JvmFinishedEvent event) throws IOException {
        if (this.taskLogsTruncater.shouldTruncateLogs(event.getJvmInfo())) {
            String user = event.getJvmInfo().getAllAttempts().get(0).getUser();
            this.taskController.truncateLogsAsUser(user, event.getJvmInfo().getAllAttempts());
        }
    }

    private void doJobStartedAction(JobStartedEvent event) {
        this.userLogCleaner.unmarkJobFromLogDeletion(event.getJobID());
    }

    private void doJobCompletedAction(JobCompletedEvent event) {
        this.userLogCleaner.markJobLogsForDeletion(event.getJobCompletionTime(), event.getRetainHours(), event.getJobID());
    }

    private void doDeleteJobAction(DeleteJobEvent event) throws IOException {
        this.userLogCleaner.deleteJobLogs(event.getJobID());
    }

    public void addLogEvent(UserLogEvent event) {
        this.userLogEvents.add(event);
    }

    public UserLogCleaner getUserLogCleaner() {
        return this.userLogCleaner;
    }
}

