/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.exceptions.UnableToCreateStatementException;
import org.skife.jdbi.v2.tweak.StatementLocator;

public class ClasspathStatementLocator
implements StatementLocator {
    private final ConcurrentMap<String, String> found = new ConcurrentHashMap<String, String>();
    private static final String sep = "/";

    public static boolean looksLikeSql(String sql) {
        String local = ClasspathStatementLocator.left(ClasspathStatementLocator.stripStart(sql), 7).toLowerCase();
        return local.startsWith("insert ") || local.startsWith("update ") || local.startsWith("select ") || local.startsWith("call ") || local.startsWith("delete ") || local.startsWith("create ") || local.startsWith("alter ") || local.startsWith("drop ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String locate(String name, StatementContext ctx) {
        String filename;
        String cache_key = ctx.getSqlObjectType() != null ? '/' + ClasspathStatementLocator.mungify(ctx.getSqlObjectType().getName() + '.' + name) + ".sql" : name;
        if (this.found.containsKey(cache_key)) {
            return (String)this.found.get(cache_key);
        }
        if (ClasspathStatementLocator.looksLikeSql(name)) {
            this.found.putIfAbsent(cache_key, name);
            return name;
        }
        ClassLoader loader = ClasspathStatementLocator.selectClassLoader();
        BufferedReader reader = null;
        InputStream in_stream = loader.getResourceAsStream(name);
        if (in_stream == null) {
            in_stream = loader.getResourceAsStream(name + ".sql");
        }
        if (in_stream == null && ctx.getSqlObjectType() != null && (in_stream = loader.getResourceAsStream(filename = '/' + ClasspathStatementLocator.mungify(ctx.getSqlObjectType().getName() + '.' + name) + ".sql")) == null) {
            in_stream = ctx.getSqlObjectType().getResourceAsStream(filename);
        }
        if (in_stream == null) {
            this.found.putIfAbsent(cache_key, name);
            filename = name;
            return filename;
        }
        StringBuffer buffer = new StringBuffer();
        reader = new BufferedReader(new InputStreamReader(in_stream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (ClasspathStatementLocator.isComment(line)) continue;
                buffer.append(line).append(" ");
            }
        }
        catch (IOException e) {
            throw new UnableToCreateStatementException(e.getMessage(), e, ctx);
        }
        String sql = buffer.toString();
        this.found.putIfAbsent(cache_key, sql);
        String string = buffer.toString();
        return string;
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static ClassLoader selectClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : ClasspathStatementLocator.class.getClassLoader();
        return loader;
    }

    private static boolean isComment(String line) {
        return line.startsWith("#") || line.startsWith("--") || line.startsWith("//");
    }

    private static String mungify(String path) {
        return path.replaceAll("\\.", Matcher.quoteReplacement(sep));
    }

    private static String stripStart(String str) {
        int start;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return "";
        }
        for (start = 0; start != strLen && Character.isWhitespace(str.charAt(start)); ++start) {
        }
        return str.substring(start);
    }

    private static String left(String str, int len) {
        if (str == null || len < 0) {
            return "";
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }
}

