/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.skife.jdbi.cglib.proxy.Enhancer;
import org.skife.jdbi.cglib.proxy.Factory;
import org.skife.jdbi.cglib.proxy.MethodInterceptor;
import org.skife.jdbi.cglib.proxy.MethodProxy;
import org.skife.jdbi.com.fasterxml.classmate.MemberResolver;
import org.skife.jdbi.com.fasterxml.classmate.ResolvedType;
import org.skife.jdbi.com.fasterxml.classmate.ResolvedTypeWithMembers;
import org.skife.jdbi.com.fasterxml.classmate.TypeResolver;
import org.skife.jdbi.com.fasterxml.classmate.members.ResolvedMethod;
import org.skife.jdbi.v2.sqlobject.BatchHandler;
import org.skife.jdbi.v2.sqlobject.CallHandler;
import org.skife.jdbi.v2.sqlobject.CloseHandler;
import org.skife.jdbi.v2.sqlobject.CloseInternalDoNotUseThisClass;
import org.skife.jdbi.v2.sqlobject.CreateSqlObject;
import org.skife.jdbi.v2.sqlobject.CreateSqlObjectHandler;
import org.skife.jdbi.v2.sqlobject.EqualsHandler;
import org.skife.jdbi.v2.sqlobject.GetHandleHelper;
import org.skife.jdbi.v2.sqlobject.HandleDing;
import org.skife.jdbi.v2.sqlobject.Handler;
import org.skife.jdbi.v2.sqlobject.HashCodeHandler;
import org.skife.jdbi.v2.sqlobject.PassThroughHandler;
import org.skife.jdbi.v2.sqlobject.PassThroughTransactionHandler;
import org.skife.jdbi.v2.sqlobject.QueryHandler;
import org.skife.jdbi.v2.sqlobject.ResultReturnThing;
import org.skife.jdbi.v2.sqlobject.SqlBatch;
import org.skife.jdbi.v2.sqlobject.SqlCall;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.ToStringHandler;
import org.skife.jdbi.v2.sqlobject.Transaction;
import org.skife.jdbi.v2.sqlobject.TransactionalHelper;
import org.skife.jdbi.v2.sqlobject.TransmogrifierHelper;
import org.skife.jdbi.v2.sqlobject.UpdateHandler;

class SqlObject {
    private static final TypeResolver typeResolver = new TypeResolver();
    private static final Map<Method, Handler> mixinHandlers = new HashMap<Method, Handler>();
    private static final ConcurrentMap<Class<?>, Map<Method, Handler>> handlersCache = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, Factory> factories = new ConcurrentHashMap();
    private final Map<Method, Handler> handlers;
    private final HandleDing ding;

    static <T> T buildSqlObject(Class<T> sqlObjectType, HandleDing handle) {
        if (!factories.containsKey(sqlObjectType)) {
            Enhancer e = new Enhancer();
            e.setClassLoader(sqlObjectType.getClassLoader());
            ArrayList<Class> interfaces = new ArrayList<Class>();
            interfaces.add(CloseInternalDoNotUseThisClass.class);
            if (sqlObjectType.isInterface()) {
                interfaces.add(sqlObjectType);
            } else {
                e.setSuperclass(sqlObjectType);
            }
            e.setInterfaces(interfaces.toArray(new Class[interfaces.size()]));
            final SqlObject so = new SqlObject(SqlObject.buildHandlersFor(sqlObjectType), handle);
            e.setCallback(new MethodInterceptor(){

                @Override
                public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
                    return so.invoke(o, method, objects, methodProxy);
                }
            });
            Object t = e.create();
            factories.putIfAbsent(sqlObjectType, (Factory)t);
            return (T)t;
        }
        Factory f = (Factory)factories.get(sqlObjectType);
        final SqlObject so = new SqlObject(SqlObject.buildHandlersFor(sqlObjectType), handle);
        return (T)f.newInstance(new MethodInterceptor(){

            @Override
            public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
                return so.invoke(o, method, objects, methodProxy);
            }
        });
    }

    private static Map<Method, Handler> buildHandlersFor(Class<?> sqlObjectType) {
        if (handlersCache.containsKey(sqlObjectType)) {
            return (Map)handlersCache.get(sqlObjectType);
        }
        MemberResolver mr = new MemberResolver(typeResolver);
        ResolvedType sql_object_type = typeResolver.resolve(sqlObjectType);
        ResolvedTypeWithMembers d = mr.resolve(sql_object_type, null, null);
        HashMap<Method, Handler> handlers = new HashMap<Method, Handler>();
        for (ResolvedMethod method : d.getMemberMethods()) {
            Method raw_method = method.getRawMember();
            if (raw_method.isAnnotationPresent(SqlQuery.class)) {
                handlers.put(raw_method, new QueryHandler(sqlObjectType, method, ResultReturnThing.forType(method)));
                continue;
            }
            if (raw_method.isAnnotationPresent(SqlUpdate.class)) {
                handlers.put(raw_method, new UpdateHandler(sqlObjectType, method));
                continue;
            }
            if (raw_method.isAnnotationPresent(SqlBatch.class)) {
                handlers.put(raw_method, new BatchHandler(sqlObjectType, method));
                continue;
            }
            if (raw_method.isAnnotationPresent(SqlCall.class)) {
                handlers.put(raw_method, new CallHandler(sqlObjectType, method));
                continue;
            }
            if (raw_method.isAnnotationPresent(CreateSqlObject.class)) {
                handlers.put(raw_method, new CreateSqlObjectHandler(raw_method.getReturnType()));
                continue;
            }
            if (method.getName().equals("close") && method.getRawMember().getParameterTypes().length == 0) {
                handlers.put(raw_method, new CloseHandler());
                continue;
            }
            if (raw_method.isAnnotationPresent(Transaction.class)) {
                handlers.put(raw_method, new PassThroughTransactionHandler(raw_method, raw_method.getAnnotation(Transaction.class)));
                continue;
            }
            if (mixinHandlers.containsKey(raw_method)) {
                handlers.put(raw_method, mixinHandlers.get(raw_method));
                continue;
            }
            handlers.put(raw_method, new PassThroughHandler(raw_method));
        }
        handlers.putAll(CloseInternalDoNotUseThisClass.Helper.handlers());
        handlers.putAll(EqualsHandler.handler());
        handlers.putAll(ToStringHandler.handler(sqlObjectType.getName()));
        handlers.putAll(HashCodeHandler.handler());
        return handlers;
    }

    public SqlObject(Map<Method, Handler> handlers, HandleDing ding) {
        this.handlers = handlers;
        this.ding = ding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args, MethodProxy mp) throws Throwable {
        try {
            this.ding.retain(method.toString());
            Object object = this.handlers.get(method).invoke(this.ding, proxy, args, mp);
            return object;
        }
        finally {
            this.ding.release(method.toString());
        }
    }

    public static void close(Object sqlObject) {
        if (!(sqlObject instanceof CloseInternalDoNotUseThisClass)) {
            throw new IllegalArgumentException(sqlObject + " is not a sql object");
        }
        CloseInternalDoNotUseThisClass closer = (CloseInternalDoNotUseThisClass)sqlObject;
        closer.___jdbi_close___();
    }

    static String getSql(SqlCall q, Method m) {
        if ("  $#@!!@#%  ".equals(q.value())) {
            return m.getName();
        }
        return q.value();
    }

    static String getSql(SqlQuery q, Method m) {
        if ("  $#@!!@#%  ".equals(q.value())) {
            return m.getName();
        }
        return q.value();
    }

    static String getSql(SqlUpdate q, Method m) {
        if ("  $#@!!@#%  ".equals(q.value())) {
            return m.getName();
        }
        return q.value();
    }

    static String getSql(SqlBatch q, Method m) {
        if ("  $#@!!@#%  ".equals(q.value())) {
            return m.getName();
        }
        return q.value();
    }

    static {
        mixinHandlers.putAll(TransactionalHelper.handlers());
        mixinHandlers.putAll(GetHandleHelper.handlers());
        mixinHandlers.putAll(TransmogrifierHelper.handlers());
    }
}

