/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject.stringtemplate;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.regex.Matcher;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.sqlobject.stringtemplate.Base64;
import org.skife.jdbi.v2.tweak.StatementLocator;

public class StringTemplate3StatementLocator
implements StatementLocator {
    private final StringTemplateGroup group;
    private final StringTemplateGroup literals = new StringTemplateGroup("literals", AngleBracketTemplateLexer.class);
    private boolean treatLiteralsAsTemplates;
    private static final String sep = "/";

    public StringTemplate3StatementLocator(Class baseClass) {
        this(StringTemplate3StatementLocator.mungify(sep + baseClass.getName()) + ".sql.stg", false, false);
    }

    public StringTemplate3StatementLocator(Class baseClass, boolean allowImplicitTemplateGroup, boolean treatLiteralsAsTemplates) {
        this(StringTemplate3StatementLocator.mungify(sep + baseClass.getName()) + ".sql.stg", allowImplicitTemplateGroup, treatLiteralsAsTemplates);
    }

    public StringTemplate3StatementLocator(String templateGroupFilePathOnClasspath) {
        this(templateGroupFilePathOnClasspath, false, false);
    }

    public StringTemplate3StatementLocator(String templateGroupFilePathOnClasspath, boolean allowImplicitTemplateGroup, boolean treatLiteralsAsTemplates) {
        this.treatLiteralsAsTemplates = treatLiteralsAsTemplates;
        InputStream ins = this.getClass().getResourceAsStream(templateGroupFilePathOnClasspath);
        if (allowImplicitTemplateGroup && ins == null) {
            this.group = new StringTemplateGroup("empty template group", AngleBracketTemplateLexer.class);
        } else {
            if (ins == null) {
                throw new IllegalStateException("unable to find group file " + templateGroupFilePathOnClasspath + " on classpath");
            }
            InputStreamReader reader = new InputStreamReader(ins);
            try {
                this.group = new StringTemplateGroup((Reader)reader, AngleBracketTemplateLexer.class);
                reader.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("unable to load string template group " + templateGroupFilePathOnClasspath, e);
            }
        }
    }

    @Override
    public String locate(String name, StatementContext ctx) throws Exception {
        if (this.group.isDefined(name)) {
            StringTemplate t = this.group.lookupTemplate(name);
            for (Map.Entry<String, Object> entry : ctx.getAttributes().entrySet()) {
                t.setAttribute(entry.getKey(), entry.getValue());
            }
            return t.toString();
        }
        if (this.treatLiteralsAsTemplates) {
            String key = new String(new Base64().encode(name.getBytes()));
            if (!this.literals.isDefined(key)) {
                this.literals.defineTemplate(key, name);
            }
            StringTemplate t = this.literals.lookupTemplate(key);
            for (Map.Entry<String, Object> entry : ctx.getAttributes().entrySet()) {
                t.setAttribute(entry.getKey(), entry.getValue());
            }
            return t.toString();
        }
        return name;
    }

    private static String mungify(String path) {
        return path.replaceAll("\\.", Matcher.quoteReplacement(sep));
    }
}

