/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.io.CountingInputStream;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.AbstractFuture;
import io.airlift.http.client.AsyncHttpClient;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.Request;
import io.airlift.http.client.RequestStats;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.jetty.JettyIoPool;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.CookieStore;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.Socks4Proxy;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public class JettyHttpClient
implements AsyncHttpClient {
    private final HttpClient httpClient;
    private final long maxContentLength;
    private final RequestStats stats = new RequestStats();
    private final List<HttpRequestFilter> requestFilters;
    private final Exception created = new Exception();
    private final String name;

    public JettyHttpClient() {
        this(new HttpClientConfig(), (Iterable<? extends HttpRequestFilter>)ImmutableList.of());
    }

    public JettyHttpClient(HttpClientConfig config) {
        this(config, (Iterable<? extends HttpRequestFilter>)ImmutableList.of());
    }

    public JettyHttpClient(HttpClientConfig config, Iterable<? extends HttpRequestFilter> requestFilters) {
        this.name = "Anonymous";
        this.maxContentLength = ((HttpClientConfig)Preconditions.checkNotNull((Object)config, (Object)"config is null")).getMaxContentLength().toBytes();
        this.httpClient = this.createHttpClient(config, this.created);
        try {
            this.httpClient.start();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.requestFilters = ImmutableList.copyOf(requestFilters);
    }

    public JettyHttpClient(HttpClientConfig config, JettyIoPool jettyIoPool, Iterable<? extends HttpRequestFilter> requestFilters) {
        this.name = jettyIoPool.getName();
        this.maxContentLength = ((HttpClientConfig)Preconditions.checkNotNull((Object)config, (Object)"config is null")).getMaxContentLength().toBytes();
        this.httpClient = this.createHttpClient(config, this.created);
        this.httpClient.setExecutor(jettyIoPool.getExecutor());
        this.httpClient.setByteBufferPool(jettyIoPool.setByteBufferPool());
        this.httpClient.setScheduler(jettyIoPool.setScheduler());
        try {
            this.httpClient.start();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.requestFilters = ImmutableList.copyOf(requestFilters);
    }

    private HttpClient createHttpClient(HttpClientConfig config, Exception created) {
        HostAndPort socksProxy;
        created.fillInStackTrace();
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setEndpointIdentificationAlgorithm("HTTPS");
        if (config.getKeyStorePath() != null) {
            sslContextFactory.setKeyStorePath(config.getKeyStorePath());
            sslContextFactory.setKeyStorePassword(config.getKeyStorePassword());
        }
        HttpClient httpClient = new HttpClient(sslContextFactory);
        httpClient.setMaxConnectionsPerDestination(config.getMaxConnectionsPerServer());
        httpClient.setCookieStore((CookieStore)new HttpCookieStore.Empty());
        long idleTimeout = Long.MAX_VALUE;
        if (config.getKeepAliveInterval() != null) {
            idleTimeout = Math.min(idleTimeout, config.getKeepAliveInterval().toMillis());
        }
        if (config.getReadTimeout() != null) {
            idleTimeout = Math.min(idleTimeout, config.getReadTimeout().toMillis());
        }
        if (idleTimeout != Long.MAX_VALUE) {
            httpClient.setIdleTimeout(idleTimeout);
        }
        if (config.getConnectTimeout() != null) {
            httpClient.setConnectTimeout(config.getConnectTimeout().toMillis());
        }
        if ((socksProxy = config.getSocksProxy()) != null) {
            httpClient.getProxyConfiguration().getProxies().add(new Socks4Proxy(socksProxy.getHostText(), socksProxy.getPortOrDefault(1080)));
        }
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> T execute(Request request, ResponseHandler<T, E> responseHandler) throws E {
        T value;
        org.eclipse.jetty.client.api.Response response;
        long requestStart = System.nanoTime();
        request = this.applyRequestFilters(request);
        HttpRequest jettyRequest = this.buildJettyRequest(request);
        InputStreamResponseListener listener = new InputStreamResponseListener(this.maxContentLength){

            public void onContent(org.eclipse.jetty.client.api.Response response, ByteBuffer content) {
                if (content.remaining() == 0) {
                    return;
                }
                super.onContent(response, content);
            }
        };
        jettyRequest.send((Response.CompleteListener)listener);
        try {
            response = listener.get(this.httpClient.getIdleTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return responseHandler.handleException(request, e);
        }
        catch (TimeoutException e) {
            return responseHandler.handleException(request, e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                return responseHandler.handleException(request, (Exception)cause);
            }
            return responseHandler.handleException(request, new RuntimeException(cause));
        }
        long responseStart = System.nanoTime();
        JettyResponse jettyResponse = null;
        try {
            jettyResponse = new JettyResponse(response, listener.getInputStream());
            value = responseHandler.handle(request, jettyResponse);
        }
        finally {
            JettyHttpClient.recordRequestComplete(this.stats, request, requestStart, jettyResponse, responseStart);
        }
        return value;
    }

    @Override
    public <T, E extends Exception> HttpClient.HttpResponseFuture<T> executeAsync(Request request, ResponseHandler<T, E> responseHandler) {
        Preconditions.checkNotNull((Object)request, (Object)"request is null");
        Preconditions.checkNotNull(responseHandler, (Object)"responseHandler is null");
        request = this.applyRequestFilters(request);
        HttpRequest jettyRequest = this.buildJettyRequest(request);
        final JettyResponseFuture<T, E> future = new JettyResponseFuture<T, E>(request, (org.eclipse.jetty.client.api.Request)jettyRequest, responseHandler, this.stats);
        BufferingResponseListener listener = new BufferingResponseListener(Ints.checkedCast((long)new DataSize(10.0, DataSize.Unit.MEGABYTE).toBytes())){

            public void onComplete(Result result) {
                Throwable throwable = result.getFailure();
                if (throwable != null) {
                    future.failed(throwable);
                } else {
                    future.completed(result.getResponse(), this.getContent());
                }
            }
        };
        try {
            jettyRequest.send((Response.CompleteListener)listener);
        }
        catch (RuntimeException e) {
            future.failed(e);
        }
        return future;
    }

    private Request applyRequestFilters(Request request) {
        for (HttpRequestFilter requestFilter : this.requestFilters) {
            request = requestFilter.filterRequest(request);
        }
        return request;
    }

    private HttpRequest buildJettyRequest(Request finalRequest) {
        HttpRequest jettyRequest = (HttpRequest)this.httpClient.newRequest(finalRequest.getUri());
        jettyRequest.getHeaders().remove(HttpHeader.USER_AGENT);
        jettyRequest.method(finalRequest.getMethod());
        for (Map.Entry entry : finalRequest.getHeaders().entries()) {
            jettyRequest.header((String)entry.getKey(), (String)entry.getValue());
        }
        BodyGenerator bodyGenerator = finalRequest.getBodyGenerator();
        if (bodyGenerator != null) {
            if (bodyGenerator instanceof StaticBodyGenerator) {
                StaticBodyGenerator staticBodyGenerator = (StaticBodyGenerator)bodyGenerator;
                jettyRequest.content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{staticBodyGenerator.getBody()}));
            } else {
                jettyRequest.content((ContentProvider)new BodyGeneratorContentProvider(bodyGenerator, this.httpClient.getExecutor()));
            }
        }
        return jettyRequest;
    }

    public List<HttpRequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    @Override
    @Managed
    @Flatten
    public RequestStats getStats() {
        return this.stats;
    }

    @Override
    public void close() {
        try {
            this.httpClient.stop();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void recordRequestComplete(RequestStats requestStats, Request request, long requestStart, JettyResponse response, long responseStart) {
        if (response == null) {
            return;
        }
        Duration responseProcessingTime = Duration.nanosSince((long)responseStart);
        Duration requestProcessingTime = new Duration((double)(responseStart - requestStart), TimeUnit.NANOSECONDS);
        requestStats.record(request.getMethod(), response.getStatusCode(), response.getBytesRead(), response.getBytesRead(), requestProcessingTime, responseProcessingTime);
    }

    private static class BodyGeneratorContentProvider
    implements ContentProvider {
        private static final ByteBuffer DONE = ByteBuffer.allocate(0);
        private static final ByteBuffer EXCEPTION = ByteBuffer.allocate(0);
        private final BodyGenerator bodyGenerator;
        private final Executor executor;

        public BodyGeneratorContentProvider(BodyGenerator bodyGenerator, Executor executor) {
            this.bodyGenerator = bodyGenerator;
            this.executor = executor;
        }

        public long getLength() {
            return -1L;
        }

        public Iterator<ByteBuffer> iterator() {
            final ArrayBlockingQueue chunks = new ArrayBlockingQueue(16);
            final AtomicReference exception = new AtomicReference();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    BodyGeneratorOutputStream out = new BodyGeneratorOutputStream(chunks);
                    try {
                        BodyGeneratorContentProvider.this.bodyGenerator.write(out);
                        out.close();
                    }
                    catch (Exception e) {
                        exception.set(e);
                        chunks.add(EXCEPTION);
                    }
                }
            });
            return new AbstractIterator<ByteBuffer>(){

                protected ByteBuffer computeNext() {
                    ByteBuffer chunk;
                    try {
                        chunk = (ByteBuffer)chunks.take();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException("Interrupted", e);
                    }
                    if (chunk == EXCEPTION) {
                        throw Throwables.propagate((Throwable)((Throwable)exception.get()));
                    }
                    if (chunk == DONE) {
                        return (ByteBuffer)this.endOfData();
                    }
                    return chunk;
                }
            };
        }

        private final class BodyGeneratorOutputStream
        extends OutputStream {
            private final BlockingQueue<ByteBuffer> chunks;

            private BodyGeneratorOutputStream(BlockingQueue<ByteBuffer> chunks) {
                this.chunks = chunks;
            }

            @Override
            public void write(int b) throws IOException {
                try {
                    this.chunks.put(ByteBuffer.wrap(new byte[]{(byte)b}));
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                try {
                    byte[] copy = Arrays.copyOfRange(b, off, len);
                    this.chunks.put(ByteBuffer.wrap(copy));
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }

            @Override
            public void close() throws IOException {
                try {
                    this.chunks.put(DONE);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
        }
    }

    private static class JettyResponseFuture<T, E extends Exception>
    extends AbstractFuture<T>
    implements HttpClient.HttpResponseFuture<T> {
        private static final Logger log = Logger.get(JettyResponseFuture.class);
        private final long requestStart = System.nanoTime();
        private final AtomicReference<JettyAsyncHttpState> state = new AtomicReference<JettyAsyncHttpState>(JettyAsyncHttpState.WAITING_FOR_CONNECTION);
        private final Request request;
        private final org.eclipse.jetty.client.api.Request jettyRequest;
        private final ResponseHandler<T, E> responseHandler;
        private final RequestStats stats;

        public JettyResponseFuture(Request request, org.eclipse.jetty.client.api.Request jettyRequest, ResponseHandler<T, E> responseHandler, RequestStats stats) {
            this.request = request;
            this.jettyRequest = jettyRequest;
            this.responseHandler = responseHandler;
            this.stats = stats;
        }

        @Override
        public String getState() {
            return this.state.get().toString();
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            this.state.set(JettyAsyncHttpState.CANCELED);
            this.jettyRequest.abort((Throwable)new CancellationException());
            return super.cancel(mayInterruptIfRunning);
        }

        protected void completed(org.eclipse.jetty.client.api.Response response, byte[] content) {
            T value;
            if (this.state.get() == JettyAsyncHttpState.CANCELED) {
                return;
            }
            try {
                value = this.processResponse(response, content);
            }
            catch (Throwable e) {
                this.storeException(e);
                return;
            }
            this.state.set(JettyAsyncHttpState.DONE);
            this.set(value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private T processResponse(org.eclipse.jetty.client.api.Response response, byte[] content) throws E {
            T value;
            long responseStart = System.nanoTime();
            this.state.set(JettyAsyncHttpState.PROCESSING_RESPONSE);
            JettyResponse jettyResponse = null;
            try {
                jettyResponse = new JettyResponse(response, content);
                value = this.responseHandler.handle(this.request, jettyResponse);
            }
            finally {
                JettyHttpClient.recordRequestComplete(this.stats, this.request, this.requestStart, jettyResponse, responseStart);
            }
            return value;
        }

        protected void failed(Throwable throwable) {
            if (this.state.get() == JettyAsyncHttpState.CANCELED) {
                return;
            }
            if (throwable instanceof Exception) {
                try {
                    T value = this.responseHandler.handleException(this.request, (Exception)throwable);
                    this.state.set(JettyAsyncHttpState.DONE);
                    this.set(value);
                    return;
                }
                catch (Throwable newThrowable) {
                    throwable = newThrowable;
                }
            }
            this.storeException(throwable);
        }

        private void storeException(Throwable throwable) {
            if (throwable instanceof CancellationException) {
                this.state.set(JettyAsyncHttpState.CANCELED);
            } else {
                this.state.set(JettyAsyncHttpState.FAILED);
            }
            if (throwable == null) {
                throwable = new Throwable("Throwable is null");
                log.error(throwable, "Something is broken");
            }
            this.setException(throwable);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("requestStart", this.requestStart).add("state", this.state).add("request", (Object)this.request).toString();
        }

        public static enum JettyAsyncHttpState {
            WAITING_FOR_CONNECTION,
            SENDING_REQUEST,
            WAITING_FOR_RESPONSE,
            PROCESSING_RESPONSE,
            DONE,
            FAILED,
            CANCELED;

        }
    }

    private static class JettyResponse
    implements Response {
        private final org.eclipse.jetty.client.api.Response response;
        private final CountingInputStream inputStream;

        public JettyResponse(org.eclipse.jetty.client.api.Response response, byte[] content) {
            this(response, new ByteArrayInputStream(content));
        }

        public JettyResponse(org.eclipse.jetty.client.api.Response response, InputStream inputStream) {
            this.response = response;
            this.inputStream = new CountingInputStream(inputStream);
        }

        @Override
        public int getStatusCode() {
            return this.response.getStatus();
        }

        @Override
        public String getStatusMessage() {
            return this.response.getReason();
        }

        @Override
        public String getHeader(String name) {
            return this.response.getHeaders().getStringField(name);
        }

        @Override
        public ListMultimap<String, String> getHeaders() {
            HttpFields headers = this.response.getHeaders();
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            for (String name : headers.getFieldNamesCollection()) {
                for (String value : headers.getValuesList(name)) {
                    builder.put((Object)name, (Object)value);
                }
            }
            return builder.build();
        }

        @Override
        public long getBytesRead() {
            return this.inputStream.getCount();
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }
    }
}

