/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.shaded.org.iq80.snappy;

import com.facebook.presto.hive.shaded.org.iq80.snappy.Memory;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

class UnsafeMemory
implements Memory {
    private static final Unsafe unsafe;
    private static final long BYTE_ARRAY_OFFSET;
    private static final long SHORT_ARRAY_OFFSET;
    private static final long SHORT_ARRAY_STRIDE;

    UnsafeMemory() {
    }

    @Override
    public boolean fastAccessSupported() {
        return true;
    }

    @Override
    public int lookupShort(short[] data, int index) {
        assert (index >= 0);
        assert (index <= data.length);
        return unsafe.getShort(data, SHORT_ARRAY_OFFSET + (long)index * SHORT_ARRAY_STRIDE) & 0xFFFF;
    }

    @Override
    public int loadByte(byte[] data, int index) {
        assert (index >= 0);
        assert (index <= data.length);
        return unsafe.getByte(data, BYTE_ARRAY_OFFSET + (long)index) & 0xFF;
    }

    @Override
    public int loadInt(byte[] data, int index) {
        assert (index >= 0);
        assert (index + 4 <= data.length);
        return unsafe.getInt(data, BYTE_ARRAY_OFFSET + (long)index);
    }

    @Override
    public void copyLong(byte[] src, int srcIndex, byte[] dest, int destIndex) {
        assert (srcIndex >= 0);
        assert (srcIndex + 8 <= src.length);
        assert (destIndex >= 0);
        assert (destIndex + 8 <= dest.length);
        long value = unsafe.getLong(src, BYTE_ARRAY_OFFSET + (long)srcIndex);
        unsafe.putLong(dest, BYTE_ARRAY_OFFSET + (long)destIndex, value);
    }

    @Override
    public long loadLong(byte[] data, int index) {
        assert (index > 0);
        assert (index + 4 < data.length);
        return unsafe.getLong(data, BYTE_ARRAY_OFFSET + (long)index);
    }

    @Override
    public void copyMemory(byte[] input, int inputIndex, byte[] output, int outputIndex, int length) {
        assert (inputIndex >= 0);
        assert (inputIndex + length <= input.length);
        assert (outputIndex >= 0);
        assert (outputIndex + length <= output.length);
        unsafe.copyMemory(input, BYTE_ARRAY_OFFSET + (long)inputIndex, output, BYTE_ARRAY_OFFSET + (long)outputIndex, length);
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            unsafe = (Unsafe)theUnsafe.get(null);
            new UnsafeMemory().copyMemory(new byte[1], 0, new byte[1], 0, 1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        BYTE_ARRAY_OFFSET = unsafe.arrayBaseOffset(byte[].class);
        SHORT_ARRAY_OFFSET = unsafe.arrayBaseOffset(short[].class);
        SHORT_ARRAY_STRIDE = unsafe.arrayIndexScale(short[].class);
    }
}

