/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.facebook.presto.hive.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hive.shaded.org.apache.commons.logging.LogFactory;
import java.io.FileNotFoundException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.MetaStoreFS;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;

public class HiveMetaStoreFsImpl
implements MetaStoreFS {
    public static final Log LOG = LogFactory.getLog("hive.metastore.hivemetastoressimpl");

    @Override
    public boolean deleteDir(FileSystem fs, Path f, boolean recursive, Configuration conf) throws MetaException {
        LOG.info("deleting  " + f);
        HadoopShims hadoopShim = ShimLoader.getHadoopShims();
        try {
            if (hadoopShim.moveToAppropriateTrash(fs, f, conf)) {
                LOG.info("Moved to trash: " + f);
                return true;
            }
            if (fs.delete(f, true)) {
                LOG.info("Deleted the diretory " + f);
                return true;
            }
            if (fs.exists(f)) {
                throw new MetaException("Unable to delete directory: " + f);
            }
        }
        catch (FileNotFoundException e) {
            return true;
        }
        catch (Exception e) {
            Warehouse.closeFs(fs);
            MetaStoreUtils.logAndThrowMetaException(e);
        }
        return false;
    }
}

