/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.events;

import com.facebook.presto.hive.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hive.shaded.org.apache.commons.logging.LogFactory;
import java.util.TimerTask;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.RawStore;

public class EventCleanerTask
extends TimerTask {
    public static final Log LOG = LogFactory.getLog(EventCleanerTask.class);
    private final HiveMetaStore.HMSHandler handler;

    public EventCleanerTask(HiveMetaStore.HMSHandler handler) {
        this.handler = handler;
    }

    @Override
    public void run() {
        try {
            RawStore ms = this.handler.getMS();
            long deleteCnt = ms.cleanupEvents();
            if (deleteCnt > 0L) {
                LOG.info("Number of events deleted from event Table: " + deleteCnt);
            }
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }
}

