/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.facebook.presto.hive.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hive.shaded.org.apache.commons.logging.LogFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.shims.HadoopShims;

public final class ArchiveUtils {
    private static final Log LOG = LogFactory.getLog(ArchiveUtils.class.getName());
    public static String ARCHIVING_LEVEL = "archiving_level";

    public static String addSlash(String s) {
        return s.endsWith("/") ? s : s + "/";
    }

    public static URI addSlash(URI u) throws HiveException {
        if (u.getPath().endsWith("/")) {
            return u;
        }
        try {
            return new URI(u.getScheme(), u.getAuthority(), u.getPath() + "/", u.getQuery(), u.getFragment());
        }
        catch (URISyntaxException e) {
            throw new HiveException("Couldn't append slash to a URI", e);
        }
    }

    public static boolean isArchived(Partition p) {
        Map<String, String> params = p.getParameters();
        return "true".equalsIgnoreCase(params.get("is_archived"));
    }

    public static int getArchivingLevel(Partition p) throws HiveException {
        if (!ArchiveUtils.isArchived(p)) {
            throw new HiveException("Getting level of unarchived partition");
        }
        Map<String, String> params = p.getParameters();
        String lv = params.get(ARCHIVING_LEVEL);
        if (lv != null) {
            return Integer.parseInt(lv);
        }
        return p.getValues().size();
    }

    public static String getPartialName(Partition p, int level) throws HiveException {
        List<FieldSchema> ffields = p.getTable().getPartCols();
        ArrayList<FieldSchema> fields = new ArrayList<FieldSchema>(level);
        List<String> fvalues = p.getValues();
        ArrayList<String> values = new ArrayList<String>(level);
        for (int i = 0; i < level; ++i) {
            FieldSchema fs = ffields.get(i);
            String s = fvalues.get(i);
            fields.add(fs);
            values.add(s);
        }
        try {
            return Warehouse.makePartName(fields, values);
        }
        catch (MetaException e) {
            throw new HiveException("Wasn't able to generate name for partial specification");
        }
    }

    public static String conflictingArchiveNameOrNull(Hive db, Table tbl, LinkedHashMap<String, String> partSpec) throws HiveException {
        List<FieldSchema> partKeys = tbl.getPartitionKeys();
        int partSpecLevel = 0;
        for (FieldSchema partKey : partKeys) {
            if (!partSpec.containsKey(partKey.getName())) break;
            ++partSpecLevel;
        }
        if (partSpecLevel != partSpec.size()) {
            throw new HiveException("partspec " + partSpec + " is wrong for table " + tbl.getTableName());
        }
        HashMap<String, String> spec = new HashMap<String, String>(partSpec);
        LinkedList<String> reversedKeys = new LinkedList<String>();
        for (FieldSchema fs : tbl.getPartCols()) {
            if (!spec.containsKey(fs.getName())) continue;
            reversedKeys.add(0, fs.getName());
        }
        for (String rk : reversedKeys) {
            List<Partition> parts = db.getPartitions(tbl, spec, (short)1);
            if (parts.size() != 0) {
                Partition p = parts.get(0);
                if (!ArchiveUtils.isArchived(p)) {
                    return null;
                }
                if (ArchiveUtils.getArchivingLevel(p) > spec.size()) {
                    return null;
                }
                return ArchiveUtils.getPartialName(p, ArchiveUtils.getArchivingLevel(p));
            }
            spec.remove(rk);
        }
        return null;
    }

    public static class HarPathHelper {
        private final URI base;
        private final URI originalBase;

        public HarPathHelper(HiveConf hconf, URI archive, URI originalBase) throws HiveException {
            this.originalBase = ArchiveUtils.addSlash(originalBase);
            String parentHost = archive.getHost();
            String harHost = null;
            harHost = parentHost == null ? archive.getScheme() + "-localhost" : archive.getScheme() + "-" + parentHost;
            String path = ArchiveUtils.addSlash(archive.getPath());
            if (!path.endsWith(".har/")) {
                throw new HiveException("HAR archive path must end with .har");
            }
            try {
                this.base = new URI("har", archive.getUserInfo(), harHost, archive.getPort(), path, archive.getQuery(), archive.getFragment());
            }
            catch (URISyntaxException e) {
                throw new HiveException("Couldn't create har URI from archive URI", e);
            }
        }

        public URI getHarUri(URI original, HadoopShims shim) throws HiveException {
            URI harUri = null;
            try {
                harUri = shim.getHarUri(original, this.base, this.originalBase);
            }
            catch (URISyntaxException e) {
                throw new HiveException("Couldn't create har URI for location", e);
            }
            return harUri;
        }
    }

    public static class PartSpecInfo {
        public List<FieldSchema> fields;
        public List<String> values;

        private PartSpecInfo(List<FieldSchema> fields, List<String> values) {
            this.fields = fields;
            this.values = values;
        }

        public static PartSpecInfo create(Table tbl, Map<String, String> partSpec) throws HiveException {
            ArrayList<FieldSchema> prefixFields = new ArrayList<FieldSchema>();
            ArrayList<String> prefixValues = new ArrayList<String>();
            List<FieldSchema> partCols = tbl.getPartCols();
            Iterator<String> itrPsKeys = partSpec.keySet().iterator();
            for (FieldSchema fs : partCols) {
                if (!itrPsKeys.hasNext()) break;
                if (!itrPsKeys.next().toLowerCase().equals(fs.getName().toLowerCase())) {
                    throw new HiveException("Invalid partition specifiation: " + partSpec);
                }
                prefixFields.add(fs);
                prefixValues.add(partSpec.get(fs.getName()));
            }
            return new PartSpecInfo(prefixFields, prefixValues);
        }

        public Path createPath(Table tbl) throws HiveException {
            String prefixSubdir;
            try {
                prefixSubdir = Warehouse.makePartName(this.fields, this.values);
            }
            catch (MetaException e) {
                throw new HiveException("Unable to get partitions directories prefix", e);
            }
            URI tableDir = tbl.getDataLocation();
            if (tableDir == null) {
                throw new HiveException("Table has no location set");
            }
            return new Path(tableDir.toString(), prefixSubdir);
        }

        public String getName() throws HiveException {
            try {
                return Warehouse.makePartName(this.fields, this.values);
            }
            catch (MetaException e) {
                throw new HiveException("Unable to create partial name", e);
            }
        }
    }
}

