/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class SelectOperator
extends Operator<SelectDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient ExprNodeEvaluator[] eval;
    transient Object[] output;

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        if (((SelectDesc)this.conf).isSelStarNoCompute()) {
            this.initializeChildren(hconf);
            return;
        }
        List<ExprNodeDesc> colList = ((SelectDesc)this.conf).getColList();
        this.eval = new ExprNodeEvaluator[colList.size()];
        for (int i = 0; i < colList.size(); ++i) {
            assert (colList.get(i) != null);
            this.eval[i] = ExprNodeEvaluatorFactory.get(colList.get(i));
        }
        this.output = new Object[this.eval.length];
        this.LOG.info("SELECT " + ((StructObjectInspector)this.inputObjInspectors[0]).getTypeName());
        this.outputObjInspector = SelectOperator.initEvaluatorsAndReturnStruct(this.eval, ((SelectDesc)this.conf).getOutputColumnNames(), this.inputObjInspectors[0]);
        this.initializeChildren(hconf);
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        if (((SelectDesc)this.conf).isSelStarNoCompute()) {
            this.forward(row, this.inputObjInspectors[tag]);
            return;
        }
        for (int i = 0; i < this.eval.length; ++i) {
            try {
                this.output[i] = this.eval[i].evaluate(row);
                continue;
            }
            catch (HiveException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new HiveException("Error evaluating " + ((SelectDesc)this.conf).getColList().get(i).getExprString(), e);
            }
        }
        this.forward(this.output, this.outputObjInspector);
    }

    @Override
    public String getName() {
        return SelectOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "SEL";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.SELECT;
    }

    @Override
    public boolean supportSkewJoinOptimization() {
        return true;
    }

    @Override
    public boolean columnNamesRowResolvedCanBeObtained() {
        return true;
    }

    @Override
    public boolean supportAutomaticSortMergeJoin() {
        return true;
    }

    @Override
    public boolean supportUnionRemoveOptimization() {
        return true;
    }
}

