/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.HashTableSinkOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinMetaData;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractMapJoinKey;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.io.Writable;

public class MapJoinSingleKey
extends AbstractMapJoinKey {
    protected transient Object obj;

    public MapJoinSingleKey() {
    }

    public MapJoinSingleKey(Object obj) {
        this.obj = obj;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MapJoinSingleKey) {
            MapJoinSingleKey mObj = (MapJoinSingleKey)o;
            Object key = mObj.getObj();
            if (this.obj == null && key == null) {
                return true;
            }
            if (this.obj != null && key != null && this.obj.equals(key)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = this.obj == null ? metadataTag : 31 + this.obj.hashCode();
        return hashCode;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            HashTableSinkOperator.HashTableSinkObjectCtx ctx = MapJoinOperator.getMetadata().get(metadataTag);
            Writable val = ctx.getSerDe().getSerializedClass().newInstance();
            val.readFields((DataInput)in);
            ArrayList list = (ArrayList)ObjectInspectorUtils.copyToStandardObject(ctx.getSerDe().deserialize(val), ctx.getSerDe().getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            if (list == null) {
                this.obj = null;
                System.out.println("read empty back");
            } else {
                this.obj = list.get(0);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            HashTableSinkOperator.HashTableSinkObjectCtx ctx = HashTableSinkOperator.getMetadata().get(metadataTag);
            ArrayList<Object> list = MapJoinMetaData.getList();
            list.add(this.obj);
            Writable outVal = ctx.getSerDe().serialize(list, ctx.getStandardOI());
            outVal.write((DataOutput)out);
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
    }

    public Object getObj() {
        return this.obj;
    }

    public void setObj(Object obj) {
        this.obj = obj;
    }

    @Override
    public boolean hasAnyNulls(boolean[] nullsafes) {
        return this.obj == null && (nullsafes == null || !nullsafes[0]);
    }
}

