/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.facebook.presto.hive.shaded.com.google.protobuf.CodedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatisticsImpl;
import org.apache.hadoop.hive.ql.io.orc.CompressionCodec;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.InStream;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.StripeInformation;
import org.apache.hadoop.hive.ql.io.orc.WriterImpl;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

final class ReaderImpl
implements Reader {
    private static final int DIRECTORY_SIZE_GUESS = 16384;
    private final FileSystem fileSystem;
    private final Path path;
    private final CompressionKind compressionKind;
    private final CompressionCodec codec;
    private final int bufferSize;
    private final OrcProto.Footer footer;
    private final ObjectInspector inspector;

    @Override
    public long getNumberOfRows() {
        return this.footer.getNumberOfRows();
    }

    @Override
    public Iterable<String> getMetadataKeys() {
        ArrayList<String> result = new ArrayList<String>();
        for (OrcProto.UserMetadataItem item : this.footer.getMetadataList()) {
            result.add(item.getName());
        }
        return result;
    }

    @Override
    public ByteBuffer getMetadataValue(String key) {
        for (OrcProto.UserMetadataItem item : this.footer.getMetadataList()) {
            if (!item.hasName() || !item.getName().equals(key)) continue;
            return item.getValue().asReadOnlyByteBuffer();
        }
        throw new IllegalArgumentException("Can't find user metadata " + key);
    }

    @Override
    public CompressionKind getCompression() {
        return this.compressionKind;
    }

    @Override
    public int getCompressionSize() {
        return this.bufferSize;
    }

    @Override
    public Iterable<StripeInformation> getStripes() {
        return new Iterable<StripeInformation>(){

            @Override
            public Iterator<StripeInformation> iterator() {
                return new Iterator<StripeInformation>(){
                    private final Iterator<OrcProto.StripeInformation> inner;
                    {
                        this.inner = ReaderImpl.this.footer.getStripesList().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.inner.hasNext();
                    }

                    @Override
                    public StripeInformation next() {
                        return new StripeInformationImpl(this.inner.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove unsupported");
                    }
                };
            }
        };
    }

    @Override
    public ObjectInspector getObjectInspector() {
        return this.inspector;
    }

    @Override
    public long getContentLength() {
        return this.footer.getContentLength();
    }

    @Override
    public List<OrcProto.Type> getTypes() {
        return this.footer.getTypesList();
    }

    @Override
    public int getRowIndexStride() {
        return this.footer.getRowIndexStride();
    }

    @Override
    public ColumnStatistics[] getStatistics() {
        ColumnStatistics[] result = new ColumnStatistics[this.footer.getTypesCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ColumnStatisticsImpl.deserialize(this.footer.getStatistics(i));
        }
        return result;
    }

    ReaderImpl(FileSystem fs, Path path) throws IOException {
        this.fileSystem = fs;
        this.path = path;
        FSDataInputStream file = fs.open(path);
        long size = fs.getFileStatus(path).getLen();
        int readSize = (int)Math.min(size, 16384L);
        file.seek(size - (long)readSize);
        ByteBuffer buffer = ByteBuffer.allocate(readSize);
        file.readFully(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        byte psLen = buffer.get(readSize - 1);
        int psOffset = readSize - 1 - psLen;
        CodedInputStream in = CodedInputStream.newInstance(buffer.array(), buffer.arrayOffset() + psOffset, psLen);
        OrcProto.PostScript ps = OrcProto.PostScript.parseFrom(in);
        int footerSize = (int)ps.getFooterLength();
        this.bufferSize = (int)ps.getCompressionBlockSize();
        switch (ps.getCompression()) {
            case NONE: {
                this.compressionKind = CompressionKind.NONE;
                break;
            }
            case ZLIB: {
                this.compressionKind = CompressionKind.ZLIB;
                break;
            }
            case SNAPPY: {
                this.compressionKind = CompressionKind.SNAPPY;
                break;
            }
            case LZO: {
                this.compressionKind = CompressionKind.LZO;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown compression");
            }
        }
        this.codec = WriterImpl.createCodec(this.compressionKind);
        int extra = Math.max(0, psLen + 1 + footerSize - readSize);
        if (extra > 0) {
            file.seek(size - (long)readSize - (long)extra);
            ByteBuffer extraBuf = ByteBuffer.allocate(extra + readSize);
            file.readFully(extraBuf.array(), extraBuf.arrayOffset() + extraBuf.position(), extra);
            extraBuf.position(extra);
            extraBuf.put(buffer);
            buffer = extraBuf;
            buffer.position(0);
            buffer.limit(footerSize);
        } else {
            buffer.position(psOffset - footerSize);
            buffer.limit(psOffset);
        }
        InStream instream = InStream.create("footer", buffer, this.codec, this.bufferSize);
        this.footer = OrcProto.Footer.parseFrom(instream);
        this.inspector = OrcStruct.createObjectInspector(0, this.footer.getTypesList());
        file.close();
    }

    @Override
    public RecordReader rows(boolean[] include) throws IOException {
        return this.rows(0L, Long.MAX_VALUE, include);
    }

    @Override
    public RecordReader rows(long offset, long length, boolean[] include) throws IOException {
        return new RecordReaderImpl(this.getStripes(), this.fileSystem, this.path, offset, length, this.footer.getTypesList(), this.codec, this.bufferSize, include, this.footer.getRowIndexStride());
    }

    private static class StripeInformationImpl
    implements StripeInformation {
        private final OrcProto.StripeInformation stripe;

        StripeInformationImpl(OrcProto.StripeInformation stripe) {
            this.stripe = stripe;
        }

        @Override
        public long getOffset() {
            return this.stripe.getOffset();
        }

        @Override
        public long getDataLength() {
            return this.stripe.getDataLength();
        }

        @Override
        public long getFooterLength() {
            return this.stripe.getFooterLength();
        }

        @Override
        public long getIndexLength() {
            return this.stripe.getIndexLength();
        }

        @Override
        public long getNumberOfRows() {
            return this.stripe.getNumberOfRows();
        }

        public String toString() {
            return "offset: " + this.getOffset() + " data: " + this.getDataLength() + " rows: " + this.getNumberOfRows() + " tail: " + this.getFooterLength() + " index: " + this.getIndexLength();
        }
    }
}

