/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.facebook.presto.hive.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hive.shaded.org.apache.commons.logging.LogFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.GlobalLimitCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.QBParseInfo;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.util.StringUtils;

public class GlobalLimitOptimizer
implements Transform {
    private final Log LOG = LogFactory.getLog(GlobalLimitOptimizer.class.getName());

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        Integer tempGlobalLimit;
        Context ctx = pctx.getContext();
        HashMap<String, Operator<? extends OperatorDesc>> topOps = pctx.getTopOps();
        GlobalLimitCtx globalLimitCtx = pctx.getGlobalLimitCtx();
        HashMap<TableScanOperator, ExprNodeDesc> opToPartPruner = pctx.getOpToPartPruner();
        HashMap<TableScanOperator, PrunedPartitionList> opToPartList = pctx.getOpToPartList();
        Map<String, PrunedPartitionList> prunedPartitions = pctx.getPrunedPartitions();
        HashMap<String, SplitSample> nameToSplitSample = pctx.getNameToSplitSample();
        HashMap<TableScanOperator, Table> topToTable = pctx.getTopToTable();
        QB qb = pctx.getQB();
        HiveConf conf = pctx.getConf();
        QBParseInfo qbParseInfo = qb.getParseInfo();
        if (ctx.getTryCount() == 0 && topOps.size() == 1 && !globalLimitCtx.ifHasTransformOrUDTF() && nameToSplitSample.isEmpty() && (tempGlobalLimit = this.checkQbpForGlobalLimit(qb)) != null && tempGlobalLimit != 0) {
            TableScanOperator ts = (TableScanOperator)topOps.values().toArray()[0];
            Table tab = (Table)topToTable.get(ts);
            if (!tab.isPartitioned()) {
                if (qbParseInfo.getDestToWhereExpr().isEmpty()) {
                    globalLimitCtx.enableOpt(tempGlobalLimit);
                }
            } else if (PartitionPruner.onlyContainsPartnCols(tab, (ExprNodeDesc)opToPartPruner.get(ts))) {
                PrunedPartitionList partsList = null;
                try {
                    partsList = (PrunedPartitionList)opToPartList.get(ts);
                    if (partsList == null) {
                        partsList = PartitionPruner.prune(tab, (ExprNodeDesc)opToPartPruner.get(ts), conf, (String)topOps.keySet().toArray()[0], prunedPartitions);
                        opToPartList.put(ts, partsList);
                    }
                }
                catch (HiveException e) {
                    this.LOG.error(StringUtils.stringifyException((Throwable)e));
                    throw new SemanticException(e.getMessage(), e);
                }
                if (partsList.getUnknownPartns().size() == 0) {
                    globalLimitCtx.enableOpt(tempGlobalLimit);
                }
            }
            if (globalLimitCtx.isEnable()) {
                this.LOG.info("Qualify the optimize that reduces input size for 'limit' for limit " + globalLimitCtx.getGlobalLimit());
            }
        }
        return pctx;
    }

    private Integer checkQbpForGlobalLimit(QB localQb) {
        QBParseInfo qbParseInfo = localQb.getParseInfo();
        if (localQb.getNumSelDi() == 0 && qbParseInfo.getDestToClusterBy().isEmpty() && qbParseInfo.getDestToDistributeBy().isEmpty() && qbParseInfo.getDestToOrderBy().isEmpty() && qbParseInfo.getDestToSortBy().isEmpty() && qbParseInfo.getDestToAggregationExprs().size() <= 1 && qbParseInfo.getDestToDistinctFuncExprs().size() <= 1 && qbParseInfo.getNameToSample().isEmpty() && (qbParseInfo.getDestToAggregationExprs().size() < 1 || qbParseInfo.getDestToAggregationExprs().values().iterator().next().isEmpty()) && (qbParseInfo.getDestToDistinctFuncExprs().size() < 1 || qbParseInfo.getDestToDistinctFuncExprs().values().iterator().next().isEmpty()) && qbParseInfo.getDestToLimit().size() <= 1) {
            Integer retValue = qbParseInfo.getDestToLimit().size() == 0 ? Integer.valueOf(0) : qbParseInfo.getDestToLimit().values().iterator().next();
            for (String alias : localQb.getSubqAliases()) {
                Integer limit = this.checkQbpForGlobalLimit(localQb.getSubqForAlias(alias).getQB());
                if (limit == null) {
                    return null;
                }
                if (retValue > 0 && limit > 0) {
                    return null;
                }
                if (limit <= 0) continue;
                retValue = limit;
            }
            return retValue;
        }
        return null;
    }
}

