/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import com.facebook.presto.hive.shaded.org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.Text;

@Description(name="rtrim", value="_FUNC_(str) - Removes the trailing space characters from str ", extended="Example:\n  > SELECT _FUNC_('facebook   ') FROM src LIMIT 1;\n  'facebook'")
public class UDFRTrim
extends UDF {
    Text result = new Text();

    public Text evaluate(Text s) {
        if (s == null) {
            return null;
        }
        this.result.set(StringUtils.stripEnd(s.toString(), " "));
        return this.result;
    }
}

