/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import com.facebook.presto.hive.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hive.shaded.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.NumericHistogram;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

@Description(name="histogram_numeric", value="_FUNC_(expr, nb) - Computes a histogram on numeric 'expr' using nb bins.", extended="Example:\n> SELECT histogram_numeric(val, 3) FROM src;\n[{\"x\":100,\"y\":14.0},{\"x\":200,\"y\":22.0},{\"x\":290.5,\"y\":11.0}]\nThe return value is an array of (x,y) pairs representing the centers of the histogram's bins. As the value of 'nb' is increased, the histogram approximationgets finer-grained, but may yield artifacts around outliers. In practice, 20-40 histogram bins appear to work well, with more bins being required for skewed or smaller datasets. Note that this function creates a histogram with non-uniform bin widths. It offers no guarantees in terms of the mean-squared-error of the histogram, but in practice is comparable to the histograms produced by the R/S-Plusstatistical computing packages.")
public class GenericUDAFHistogramNumeric
extends AbstractGenericUDAFResolver {
    static final Log LOG = LogFactory.getLog(GenericUDAFHistogramNumeric.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 2) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Please specify exactly two arguments.");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + parameters[0].getTypeName() + " was passed as parameter 1.");
        }
        switch (((PrimitiveTypeInfo)parameters[0]).getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case TIMESTAMP: 
            case DECIMAL: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "Only numeric type arguments are accepted but " + parameters[0].getTypeName() + " was passed as parameter 1.");
            }
        }
        if (parameters[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(1, "Only primitive type arguments are accepted but " + parameters[1].getTypeName() + " was passed as parameter 2.");
        }
        if (((PrimitiveTypeInfo)parameters[1]).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.INT) {
            throw new UDFArgumentTypeException(1, "Only an integer argument is accepted as parameter 2, but " + parameters[1].getTypeName() + " was passed instead.");
        }
        return new GenericUDAFHistogramNumericEvaluator();
    }

    public static class GenericUDAFHistogramNumericEvaluator
    extends GenericUDAFEvaluator {
        private PrimitiveObjectInspector inputOI;
        private PrimitiveObjectInspector nbinsOI;
        private StandardListObjectInspector loi;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (m == GenericUDAFEvaluator.Mode.PARTIAL1 || m == GenericUDAFEvaluator.Mode.COMPLETE) {
                assert (parameters.length == 2);
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
                this.nbinsOI = (PrimitiveObjectInspector)parameters[1];
            } else {
                this.loi = (StandardListObjectInspector)parameters[0];
            }
            if (m == GenericUDAFEvaluator.Mode.PARTIAL1 || m == GenericUDAFEvaluator.Mode.PARTIAL2) {
                return ObjectInspectorFactory.getStandardListObjectInspector(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
            }
            ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
            foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
            ArrayList<String> fname = new ArrayList<String>();
            fname.add("x");
            fname.add("y");
            return ObjectInspectorFactory.getStandardListObjectInspector(ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi));
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StdAgg myagg = (StdAgg)agg;
            return myagg.histogram.serialize();
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StdAgg myagg = (StdAgg)agg;
            if (myagg.histogram.getUsedBins() < 1) {
                return null;
            }
            ArrayList<DoubleWritable[]> result = new ArrayList<DoubleWritable[]>();
            for (int i = 0; i < myagg.histogram.getUsedBins(); ++i) {
                DoubleWritable[] bin = new DoubleWritable[]{new DoubleWritable(myagg.histogram.getBin((int)i).x), new DoubleWritable(myagg.histogram.getBin((int)i).y)};
                result.add(bin);
            }
            return result;
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial == null) {
                return;
            }
            List<DoubleWritable> partialHistogram = this.loi.getList(partial);
            StdAgg myagg = (StdAgg)agg;
            myagg.histogram.merge(partialHistogram);
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            assert (parameters.length == 2);
            if (parameters[0] == null || parameters[1] == null) {
                return;
            }
            StdAgg myagg = (StdAgg)agg;
            if (!myagg.histogram.isReady()) {
                int nbins = PrimitiveObjectInspectorUtils.getInt(parameters[1], this.nbinsOI);
                if (nbins < 2) {
                    throw new HiveException(this.getClass().getSimpleName() + " needs nbins to be at least 2," + " but you supplied " + nbins + ".");
                }
                myagg.histogram.allocate(nbins);
            }
            double v = PrimitiveObjectInspectorUtils.getDouble(parameters[0], this.inputOI);
            myagg.histogram.add(v);
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            StdAgg result = new StdAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StdAgg myagg = (StdAgg)agg;
            myagg.histogram = new NumericHistogram();
            myagg.histogram.reset();
        }

        static class StdAgg
        implements GenericUDAFEvaluator.AggregationBuffer {
            NumericHistogram histogram;

            StdAgg() {
            }
        }
    }
}

