/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import com.facebook.presto.hive.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hive.shaded.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

@Description(name="max", value="_FUNC_(expr) - Returns the maximum value of expr")
public class GenericUDAFMax
extends AbstractGenericUDAFResolver {
    static final Log LOG = LogFactory.getLog(GenericUDAFMax.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly one argument is expected.");
        }
        ObjectInspector oi = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(parameters[0]);
        if (!ObjectInspectorUtils.compareSupported(oi)) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Cannot support comparison of map<> type or complex type containing map<>.");
        }
        return new GenericUDAFMaxEvaluator();
    }

    @UDFType(distinctLike=true)
    public static class GenericUDAFMaxEvaluator
    extends GenericUDAFEvaluator {
        ObjectInspector inputOI;
        ObjectInspector outputOI;
        boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            assert (parameters.length == 1);
            super.init(m, parameters);
            this.inputOI = parameters[0];
            this.outputOI = ObjectInspectorUtils.getStandardObjectInspector(this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
            return this.outputOI;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            MaxAgg result = new MaxAgg();
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MaxAgg myagg = (MaxAgg)agg;
            myagg.o = null;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            assert (parameters.length == 1);
            this.merge(agg, parameters[0]);
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return this.terminate(agg);
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                MaxAgg myagg = (MaxAgg)agg;
                int r = ObjectInspectorUtils.compare(myagg.o, this.outputOI, partial, this.inputOI);
                if (myagg.o == null || r < 0) {
                    myagg.o = ObjectInspectorUtils.copyToStandardObject(partial, this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
                }
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MaxAgg myagg = (MaxAgg)agg;
            return myagg.o;
        }

        static class MaxAgg
        implements GenericUDAFEvaluator.AggregationBuffer {
            Object o;

            MaxAgg() {
            }
        }
    }
}

