/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.base.Preconditions;

public abstract class AbstractRandomInt {
    private static final long MULTIPLIER = 16807L;
    private static final long MODULUS = Integer.MAX_VALUE;
    private final int expectedUsagePerRow;
    private long seed;
    private int usage;

    public AbstractRandomInt(long seed, int expectedUsagePerRow) {
        this.seed = seed;
        this.expectedUsagePerRow = expectedUsagePerRow;
    }

    protected int nextInt(int lowValue, int highValue) {
        this.nextRand();
        int intRange = highValue - lowValue + 1;
        double doubleRange = intRange;
        int valueInRange = (int)(1.0 * (double)this.seed / 2.147483647E9 * doubleRange);
        return lowValue + valueInRange;
    }

    protected long nextRand() {
        Preconditions.checkState((this.usage < this.expectedUsagePerRow ? 1 : 0) != 0, (String)"Expected random to be used only %s times per row", (Object[])new Object[]{this.expectedUsagePerRow});
        this.seed = this.seed * 16807L % Integer.MAX_VALUE;
        ++this.usage;
        return this.seed;
    }

    public void rowFinished() {
        this.advanceSeed(this.expectedUsagePerRow - this.usage);
        this.usage = 0;
    }

    public void advanceRows(long rowCount) {
        if (this.usage != 0) {
            this.rowFinished();
        }
        this.advanceSeed((long)this.expectedUsagePerRow * rowCount);
    }

    private void advanceSeed(long count) {
        long multiplier = 16807L;
        while (count > 0L) {
            if (count % 2L != 0L) {
                this.seed = multiplier * this.seed % Integer.MAX_VALUE;
            }
            count /= 2L;
            multiplier = multiplier * multiplier % Integer.MAX_VALUE;
        }
    }
}

