/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.tpch.RandomInt;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Distribution {
    private final String name;
    private final List<String> values;
    private final int[] weights;

    public Distribution(String name, Map<String, Integer> distribution) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull(distribution, (Object)"distribution is null");
        ImmutableList.Builder values = ImmutableList.builder();
        this.weights = new int[distribution.size()];
        int runningWeight = 0;
        int index = 0;
        for (Map.Entry<String, Integer> entry : distribution.entrySet()) {
            values.add((Object)entry.getKey());
            this.weights[index] = runningWeight += entry.getValue().intValue();
            ++index;
        }
        this.values = values.build();
    }

    public String getValue(int index) {
        return this.values.get(index);
    }

    public List<String> getValues() {
        return this.values;
    }

    public int getWeight(int index) {
        return this.weights[index];
    }

    public int size() {
        return this.values.size();
    }

    public String randomValue(RandomInt randomInt) {
        int i = this.randomIndex(randomInt);
        return this.values.get(i);
    }

    public int randomIndex(RandomInt randomInt) {
        int maxWeight = this.weights[this.values.size() - 1];
        int randomValue = randomInt.nextInt(1, maxWeight);
        int i = Arrays.binarySearch(this.weights, randomValue);
        if (i < 0) {
            i = -i - 1;
        }
        return Math.abs(i);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }
}

